package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.cache.UserCache;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.dao.UserDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.AreaService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserPublicServiceImpl.java
 * @Description TODO
 * @createTime 2020年08月11日 13:05:00
 */
@Service
public class UserPublicServiceImpl implements UserPublicService {

    @Autowired
    UnitsDao unitsDao;

    @Autowired
    UserDao userDao;

    @Autowired
    AreaDao areaDao;

    @Autowired
    UserCache userCache;

    @Autowired
    UnitsCache unitsCache;

    @Autowired
    UnitsService unitsService;

    @Autowired
    AreaService areaService;

    @Override
    public List<String> findByUnitNameDown(String unitName) {
        Units units = unitsDao.findByName(unitName);

        return unitsDao.findAllByAreaId(units.getAreaId()).stream().map(Units::getName).collect(Collectors.toList());
    }

    /**
     * 通过Id查询用户
     *
     * @param userId 用户id
     */
    @Override
    public User getOne(Integer userId) {
        if (userId!=null) {
            User resultEntity = userCache.findById(userId);
            return resultEntity;
        }else {
            return new User();
        }
    }

    @Override
    public List<String> findAllUnitNameByAreaId(Integer areaId) {
        List<Units> units = unitsDao.findByAreaId(areaId);
        List<Integer> areaIds = areaDao.findAllByFatherId(units.get(0).getAreaId()).stream().map(Area::getId).collect(Collectors.toList());
        List<String> unitsNameList = unitsDao.findAll().stream().filter(units1 -> areaIds.contains(units1.getAreaId())).map(Units::getName).collect(Collectors.toList());
        unitsNameList.addAll(units.stream().map(Units::getName).collect(Collectors.toList()));
        return unitsNameList;
    }

    @Override
    public Integer findUnitIdByName(String unitName) {
        return unitsDao.findByName(unitName).getUnitId();
    }

    /**
     * @param userId 用户id
     *               查询该用户同级其他用户Id
     */
    @Override
    public List<Integer> findOtherUser(Integer userId) {
        Integer unitId = userCache.findById(userId).getUnitsId();
        return userCache.findAll().stream()
                .filter(user -> user.getUnitsId().equals(unitId)&&!user.getUserId().equals(userId))
                .map(User::getUserId)
                .collect(Collectors.toList());
    }

    @Override
    public String getAreaNameByUnitName(String unitName) {
        if (unitsService.findById(findUnitIdByName(unitName)).getAreaId()!=0) {
            return areaService.findByid(unitsService.findById(findUnitIdByName(unitName)).getAreaId()).getName();
        }
        else {
            return unitName;
        }
    }

    @Override
    public String findUnitsNameByUserId(Integer userId) {
        User resultEntity = userCache.findById(userId);
        return unitsCache.findById(resultEntity.getUnitsId()).getName();
    }

    @Override
    public String findByUnitsToname(Integer unitsId) {
        return unitsDao.findById(unitsId).get().getName();
    }

    @Override
    public List<User> getAllUser() {
        return userDao.findAll();
    }

    @Override
    public List<Units> getAllUnits() {
        return unitsDao.findAll();
    }

    @Override
    public List<Integer> findAllUserIdByUnitsName(String unitName) {
        Units units = unitsDao.findByName(unitName);
        List<Integer> areaIds = areaDao.findAllByFatherId(units.getAreaId()).stream().map(Area::getId).collect(Collectors.toList());
        List<Integer> unitsIdList = unitsDao.findAll().stream().filter(units1 -> areaIds.contains(units1.getAreaId())).map(Units::getUnitId).collect(Collectors.toList());
        unitsIdList.add(units.getUnitId());
        List<User> users = userDao.findAll();
        return users.stream().filter(user -> unitsIdList.contains(user.getUnitsId())).map(User::getUserId).collect(Collectors.toList());
    }

    @Override
    public Area getArea(Integer areaId) {
        Optional<Area> area = areaDao.findById(areaId);
        return area.orElse(null);
    }
}
