package com.tykj.dev.device.user.task;

import com.tykj.dev.device.user.subject.entity.*;
import com.tykj.dev.device.user.subject.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName userRun.java
 * @Description TODO
 * @createTime 2020年07月28日 11:17:00
 */

@Slf4j
@Component
public class userRun implements CommandLineRunner {
    @Autowired
    UserService userService;

    @Autowired
    RoleService roleService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    PermissionsService permissionsService;

    @Autowired
    RolePermissionsService rolePermissionsService;

    @Override
    public void run(String... args) throws Exception {

        if (userService.findAll().size() == 0) {
            Units units = Units.toDb();
            units.setAreaId(1);
            units = unitsService.save(units);
            User user = User.toDb();
            user.setUserId(1);
            user.setUnitsId(units.getUnitId());
            user.setName("省A岗");
            user.setUsername("shena");
            userService.save(user);

            user = User.toDb();
            user.setUserId(2);
            user.setName("省B岗");
            user.setUsername("shenb");
            userService.save(user);

            units = Units.toDb();
            units.setName("市机要局");
            units.setUnitDesc("市机要局");
            units.setAreaId(2);
            units = unitsService.save(units);
            user = User.toDb();
            user.setUserId(3);
            user.setUnitsId(units.getUnitId());
            user.setName("市A岗");
            user.setUsername("shia");
            userService.save(user);
            user = User.toDb();
            user.setUserId(4);
            user.setName("市B岗");
            user.setUsername("shib");
            userService.save(user);

            units = Units.toDb();
            units.setName("区机要局");
            units.setUnitDesc("区机要局");
            units.setAreaId(3);
            units = unitsService.save(units);
            user = User.toDb();
            user.setUserId(5);
            user.setUnitsId(units.getUnitId());
            user.setName("区A岗");
            user.setUsername("qua");
            userService.save(user);
            user = User.toDb();
            user.setUserId(6);
            user.setName("区B岗");
            user.setUsername("qub");
            userService.save(user);

            permissionsRun();
            roleRun();
            rolePerssionsRun();
            userRoleRun();
            log.info("用户模块模拟数据生成");
        } else {
//            userService.updateUserPass();
            log.info("已有用户不新建");
        }
    }

    private void permissionsRun() {
        permissionsService.save(new Permissions(1, "所有权限", "/**", 0));
        permissionsService.save(new Permissions(2, "所有权限", "/user/**", 0));
    }

    private void roleRun() {
        roleService.save(new Role(1, "管理员", "系统员", new Date(), null));
        roleService.save(new Role(2, "省A专管员", "系统员", new Date(), null));
        roleService.save(new Role(3, "省B专管员", "系统员", new Date(), null));
        roleService.save(new Role(4, "市A专管员", "系统员", new Date(), null));
        roleService.save(new Role(5, "市B专管员", "系统员", new Date(), null));
        roleService.save(new Role(6, "县A专管员", "系统员", new Date(), null));
        roleService.save(new Role(7, "县A专管员", "系统员", new Date(), null));
    }

    private void rolePerssionsRun() {
        roleService.findAll().forEach(
                role -> {
                    rolePermissionsService.save(new RolePermissions(null, role.getRoleId(), 1));
                    rolePermissionsService.save(new RolePermissions(null, role.getRoleId(), 2));
                }
        );
    }

    private void userRoleRun() {
        userRoleService.save(new UserRole(1, 1, 2));
        userRoleService.save(new UserRole(2, 2, 3));
        userRoleService.save(new UserRole(3, 3, 4));
        userRoleService.save(new UserRole(4, 4, 5));
        userRoleService.save(new UserRole(5, 5, 6));
        userRoleService.save(new UserRole(6, 6, 7));

    }


}
