package com.tykj.dev.device.usereport.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.file.entity.WrodParameter;
import com.tykj.dev.device.file.service.UseReportFIleService;
import com.tykj.dev.device.usereport.service.DeviceUseReportService;
import com.tykj.dev.device.usereport.subject.domin.DeviceUseReport;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportCreateVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportDetailVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportSelectVo;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/check/report")
@AutoDocument
@Api(tags = "装备使用报告模块", description = "装备使用报告接口")
public class DeviceUseReportController {

    @Autowired
    private DeviceUseReportService deviceUseReportService;

    @Autowired
    private UseReportFIleService useReportFIleService;
    @ApiOperation(value = "模糊查询装备使用报告分页", notes = "可以通过这个接口模糊查询装备使用报告分页")
    @PostMapping("/summary")
    public ResponseEntity selectDeviceUseReport(@RequestBody DeviceUseReportSelectVo deviceUseReportSelectVo) {
        Page<DeviceUseReport> deviceUseReportEntities = deviceUseReportService.getPage(deviceUseReportSelectVo, deviceUseReportSelectVo.getPageable());
        return ResultUtil.success(deviceUseReportEntities);
    }

    @ApiOperation(value = "生成装备使用报告", notes = "可以通过这个接口生成装备使用报告")
    @PostMapping("/create")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity createDeviceUseReport(@RequestBody @Validated DeviceUseReportCreateVo deviceUseReportCreateVo) {
        return ResultUtil.success(deviceUseReportService.createReport(deviceUseReportCreateVo));
    }

    @ApiOperation(value = "查询装备使用报告详情页", notes = "查询装备使用报告详情页")
    @GetMapping("/detail/{id}")
    public ResponseEntity selectDetail(@PathVariable("id") int id) {
        DeviceUseReport d = deviceUseReportService.getOne(id);
        DeviceUseReportDetailVo deviceUseReportDetailVo = new DeviceUseReportDetailVo();
        BeanUtils.copyProperties(d, deviceUseReportDetailVo);
        //分解数量详情组合字段
        List<Integer> list = StringSplitUtil.userIdSplit(d.getReportDetail());
        if (list.size() > 7) {
            deviceUseReportDetailVo.setDeviceNumber(list.get(0));
            deviceUseReportDetailVo.setInLibraryNum(list.get(1));
            deviceUseReportDetailVo.setRepairNum(list.get(2));
            deviceUseReportDetailVo.setAllotNum(list.get(3));
            deviceUseReportDetailVo.setSendBackNum(list.get(4));
            deviceUseReportDetailVo.setDestoryNum(list.get(5));
            deviceUseReportDetailVo.setPackingNum(list.get(6));
            deviceUseReportDetailVo.setRetiredNum(list.get(7));
        }
        return ResultUtil.success(deviceUseReportDetailVo);
    }

    @ApiOperation(value = "装备使用报告下载", notes = "装备使用报告下载")
    @GetMapping("/download/{id}")
    public ResponseEntity getDownloadUrl(@PathVariable("id") int id, HttpServletResponse response, HttpServletRequest httpServletRequest) throws IOException {
        ResultObj resultObj = (ResultObj) selectDetail(id).getBody();
        DeviceUseReportDetailVo deviceUseReportDetailVo = (DeviceUseReportDetailVo) resultObj.getData();
        WrodParameter wrodParameter = new WrodParameter();

        Instant instant = deviceUseReportDetailVo.getCreateTime().toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        wrodParameter.setTime(localDateTime.getYear()+"年"+localDateTime.getMonth()+"月"+localDateTime.getMonthValue()+"日");
        wrodParameter.setUnitsName(deviceUseReportDetailVo.getUnit());
        wrodParameter.setTitle1(localDateTime.getYear() + "年度" + deviceUseReportDetailVo.getUnit()+"装备使用情况报告");
        wrodParameter.setTitle2("装备使用情况报告");
        wrodParameter.setSelfCheck("列装库内列装总数：" + deviceUseReportDetailVo.getPackingNum().toString() + ",退装总数：" + deviceUseReportDetailVo.getRetiredNum().toString() + "。");
        wrodParameter.setComfirmCheck(" ");
        wrodParameter.setTotal("度本单位在库总装备数" + deviceUseReportDetailVo.getDeviceNumber() + ";其中入库总数" + deviceUseReportDetailVo.getInLibraryNum() + ";维修总数" + deviceUseReportDetailVo.getRepairNum() + ";配发总数" + deviceUseReportDetailVo.getAllotNum() + "清退总数" + deviceUseReportDetailVo.getSendBackNum() + ";销毁总数" + deviceUseReportDetailVo.getDestoryNum() + "。");
        useReportFIleService.findToFileService(wrodParameter, response, httpServletRequest);
        return ResponseEntity.ok("下载成功");
    }
}
