package com.tykj.dev.device.usereport.service;

import com.tykj.dev.device.usereport.subject.domin.DeviceUseReport;
import com.tykj.dev.device.usereport.subject.vo.DeviceStatistics;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportCreateVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceUseReportService {

    DeviceUseReport addEntity(DeviceUseReport deviceUseReportEntity);

    /**
     * @param deviceUseReports 异步上链
     */
    void sendHash(List<DeviceUseReport> deviceUseReports);

    Page<DeviceUseReport> getPage(DeviceUseReportSelectVo deviceUseReportSelectVo, Pageable pageable);

    DeviceUseReport getOne(Integer id);

    DeviceUseReport update(DeviceUseReport deviceUseReportEntity);

    DeviceUseReport createReport(DeviceUseReportCreateVo deviceUseReportCreateVo);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省入库的统计
     */
    List<DeviceStatistics> getStorageStatistics(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省送国家维修的统计
     */
    List<DeviceStatistics> getRepairStatistics(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省销毁的统计
     */
    List<DeviceStatistics> getDestroyStatistics(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省报废的统计
     */
    List<DeviceStatistics> getScrapStatistics(Date startDate, Date endDate);

    void delete(Integer id);
}
