/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.UsbUtils;
import com.zebra.sdk.printer.SGD;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.usb4java.BufferUtils;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class LibUsbUtils {
    public static List<String> enumeratePrinters() throws ConnectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Context context = new Context();
        int n = LibUsb.init((Context)context);
        if (n < 0) {
            throw new ConnectionException("Unable to initialize libusb: " + n);
        }
        DeviceList deviceList = new DeviceList();
        n = LibUsb.getDeviceList((Context)context, (DeviceList)deviceList);
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to get device list", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        try {
            for (Device device : deviceList) {
                if (!LibUsbUtils.isZebraDevice(device)) continue;
                String string = LibUsbUtils.getSymbolicName(device);
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage(), exception);
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)deviceList, (boolean)true);
            LibUsb.exit((Context)context);
        }
        return arrayList;
    }

    public static Map<String, String> loadDeviceIdMap(String string) throws ConnectionException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        UsbUtils.addSymbolicNameAttributesToMap(string, linkedHashMap);
        String string2 = LibUsbUtils.getDeviceIdString(string);
        UsbUtils.addDeviceIdArtributesToMap(linkedHashMap, string2);
        if (UsbUtils.isZMotifPrinter(linkedHashMap)) {
            String string3 = UsbUtils.decodeZmotifSerialNumber((String)linkedHashMap.get("SERIAL_NUMBER"));
            linkedHashMap.put("SERIAL_NUMBER", string3);
        }
        return linkedHashMap;
    }

    public static String getDeviceIdString(String string) throws ConnectionException {
        String string2 = "";
        Context context = new Context();
        int n = LibUsb.init((Context)context);
        if (n < 0) {
            throw new ConnectionException("Unable to initialize libusb: " + n);
        }
        DeviceList deviceList = new DeviceList();
        n = LibUsb.getDeviceList((Context)context, (DeviceList)deviceList);
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to get device list", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        try {
            for (Device device : deviceList) {
                if (!LibUsbUtils.isZebraDevice(device)) continue;
                String string3 = "";
                try {
                    string3 = LibUsbUtils.getSymbolicName(device);
                }
                catch (Exception exception) {
                    continue;
                }
                if (!string3.equals(string)) continue;
                DeviceHandle deviceHandle = LibUsbUtils.open(device);
                string2 = LibUsbUtils.getDeviceId(deviceHandle);
                LibUsbUtils.close(deviceHandle);
                break;
            }
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage(), exception);
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)deviceList, (boolean)true);
            LibUsb.exit((Context)context);
        }
        return string2;
    }

    protected static boolean isZebraDevice(Device device) throws ConnectionException {
        boolean bl = false;
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
        int n = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)deviceDescriptor);
        if (n < 0) {
            return bl;
        }
        if (deviceDescriptor.idVendor() == 2655) {
            bl = true;
        }
        return bl;
    }

    public static void close(DeviceHandle deviceHandle) throws ConnectionException {
        int n = 0;
        int n2 = LibUsb.kernelDriverActive((DeviceHandle)deviceHandle, (int)n);
        if (n2 == 0 || (n2 = LibUsb.releaseInterface((DeviceHandle)deviceHandle, (int)n)) != 0) {
            // empty if block
        }
        if (deviceHandle != null) {
            LibUsb.close((DeviceHandle)deviceHandle);
        }
    }

    private static String getDeviceId(DeviceHandle deviceHandle) throws ConnectionException {
        String string = "";
        byte by = -95;
        by = -95;
        byte by2 = 0;
        short s = 0;
        short s2 = 0;
        ByteBuffer byteBuffer = BufferUtils.allocateByteBuffer((int)256);
        byteBuffer.clear();
        int n = LibUsb.controlTransfer((DeviceHandle)deviceHandle, (byte)by, (byte)by2, (short)s, (short)s2, (ByteBuffer)byteBuffer, (long)2000L);
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to retrieve Device ID", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        string = new String(byArray, 2, byArray.length - 2);
        return string;
    }

    public static DeviceHandle open(Device device) throws ConnectionException {
        int n = 0;
        DeviceHandle deviceHandle = new DeviceHandle();
        n = LibUsb.open((Device)device, (DeviceHandle)deviceHandle);
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to open device", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        int n2 = 0;
        n = LibUsb.kernelDriverActive((DeviceHandle)deviceHandle, (int)n2);
        if (n != 0) {
            n = LibUsb.detachKernelDriver((DeviceHandle)deviceHandle, (int)n2);
        }
        if ((n = LibUsb.claimInterface((DeviceHandle)deviceHandle, (int)n2)) != 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to claim usb interface", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        return deviceHandle;
    }

    public static String getSymbolicName(Device device) throws ConnectionException {
        int n = LibUsb.getDeviceAddress((Device)device);
        int n2 = LibUsb.getBusNumber((Device)device);
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
        int n3 = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)deviceDescriptor);
        if (n3 < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to read device descriptor", n3);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        DeviceHandle deviceHandle = new DeviceHandle();
        n3 = LibUsb.open((Device)device, (DeviceHandle)deviceHandle);
        if (n3 < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to open device", n3);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        byte by = deviceDescriptor.iProduct();
        if (by > 0) {
            string = LibUsb.getStringDescriptor((DeviceHandle)deviceHandle, (byte)by);
        }
        if ((by = deviceDescriptor.iSerialNumber()) > 0) {
            string2 = LibUsb.getStringDescriptor((DeviceHandle)deviceHandle, (byte)by);
        }
        short s = deviceDescriptor.idVendor();
        short s2 = deviceDescriptor.idProduct();
        string3 = string == null || string.isEmpty() ? String.format("usb#vid_%04x&pid_%04x#%s#bus_%03d#addr_%03d", s, s2, string2, n2, n) : String.format("usb#vid_%04x&pid_%04x#%s#bus_%03d#addr_%03d#model_%s", s, s2, string2, n2, n, string);
        LibUsb.close((DeviceHandle)deviceHandle);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadDeviceIdMap(String string, Connection connection) throws ConnectionException {
        Map<String, String> map = LibUsbUtils.loadDeviceIdMap(string);
        if (!UsbUtils.isCardPrinter(map)) {
            try {
                connection.open();
                String string2 = SGD.GET("device.unique_id", connection);
                if (string2 != null && !string2.isEmpty()) {
                    map.put("SERIAL_NUMBER", string2);
                }
            }
            catch (ConnectionException connectionException) {
            }
            finally {
                connection.close();
            }
        }
        return map;
    }
}

