/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.internal.MultipartFormReceiverStream;
import com.zebra.sdk.printer.internal.PrinterConnectionInputStream;
import com.zebra.sdk.printer.internal.PrinterConnectionInputStreamBase;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.MultipartFileRequester;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.InputStream;

public class ObjectGrabberOperation
extends PrinterOperationCaresAboutLinkOsVersion<InputStream> {
    private static final long serialVersionUID = -7856575708124729815L;
    protected long MAX_INTER_CHARACTER_DELAY_TIME = 15000L;
    private String fullObjectPath;

    public ObjectGrabberOperation(String string, Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) throws ZebraIllegalArgumentException {
        super(connection, printerLanguage, linkOsInformation);
        if (string == null || 2 >= string.length()) {
            throw new IllegalArgumentException("File name not provided");
        }
        if (string.charAt(1) != ':') {
            throw new IllegalArgumentException("Drive letter not specified");
        }
        this.fullObjectPath = string;
    }

    @Override
    public InputStream execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        return this.retrieveStreamToObject();
    }

    private void isOkToProceed() throws ConnectionException {
        if (!(this.isLinkOs2_5_OrHigher() || !(this.connection instanceof StatusConnection) && this.connection.isConnected())) {
            throw new ConnectionException("Cannot retrieve objects over status channel on this version of firmware");
        }
        if (this.isPrintingChannelInLineMode()) {
            throw new ConnectionException("Cannot retrieve objects from printer over printing channel when in line mode");
        }
    }

    private InputStream retrieveStreamToObject() throws ConnectionException {
        PrinterConnectionInputStreamBase printerConnectionInputStreamBase = null;
        if (this.shouldRequestMultipartForm()) {
            MultipartFileRequester.send(this.connection, this.fullObjectPath);
            printerConnectionInputStreamBase = new MultipartFormReceiverStream(this.connection, this.MAX_INTER_CHARACTER_DELAY_TIME);
        } else if (FileWrapper.isHzoExtension(this.fullObjectPath.substring(this.fullObjectPath.lastIndexOf(46) + 1))) {
            try {
                this.connection.write(ZPLUtilities.getHZO(this.fullObjectPath).getBytes());
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                throw new ConnectionException(zebraIllegalArgumentException.getLocalizedMessage());
            }
            printerConnectionInputStreamBase = new PrinterConnectionInputStream(this.connection, this.MAX_INTER_CHARACTER_DELAY_TIME, "</ZEBRA-ELTRON-PERSONALITY>\r\n");
        }
        return printerConnectionInputStreamBase;
    }

    private boolean shouldRequestMultipartForm() {
        return this.isLinkOs2_5_OrHigher() && (this.printerLanguage != PrinterLanguage.LINE_PRINT || this.connection instanceof StatusConnection);
    }
}

