package entity.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_retired_bill
 * 退装账单
 * @author admin
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_retired_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("退装账单")
public class DeviceRetiredBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id ;	/**
	* 省A岗id
	*/
	@ApiModelProperty(value = "省A岗id")
	private Integer userAId ;	/**
	* 省B岗id
	*/
	@ApiModelProperty(value = "省B岗id")
	private Integer userBId ;	/**
	* 退装状态(0:待审核,1:审核失败,2:退装成功)
	*/
	@ApiModelProperty(value = "退装状态(0:待审核,1:审核失败,2:退装成功)")
	private Integer retiredStatus ;	/**
	* 列装库主键id(x作为分隔符)，例如1x2,意为列装库id为1和2的退装
	*/
	@ApiModelProperty(value = "列装库主键id(x作为分隔符)，例如x1x2,意为列装库id为1和2的退装")
	private String retiredDetail ;	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId ;	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime ;	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId ;	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime ;	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag  = 0 ;

	public DeviceRetiredBill(Integer userAId, Integer userBId, Integer retiredStatus, String retiredDetail) {
		this.userAId = userAId;
		this.userBId = userBId;
		this.retiredStatus = retiredStatus;
		this.retiredDetail = retiredDetail;
	}
}
