package com.tykj.dev.device.selfcheck.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for self_examination_bill
 * 自查账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update self_examination_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("自查账单")
public class SelfCheckBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 自查周期(0:月度,1:季度,2:年度)
	*/
	@ApiModelProperty(value = "自查周期(0:月度,1:季度,2:年度)")
	private Integer cycle;
	/**
	* 自查标题
	*/
	@ApiModelProperty(value = "自查标题")
	private String title;
	/**
	* 经办人id(A岗)
	*/
	@ApiModelProperty(value = "经办人id(A岗)")
	private Integer useraId;
	/**
	* 审核人id(B岗)
	*/
	@ApiModelProperty(value = "审核人id(B岗)")
	private Integer userbId;
	/**
	* 自查时间
	*/
	@ApiModelProperty(value = "自查时间")
	private Date checkTime;
	/**
	* 自查单位
	*/
	@ApiModelProperty(value = "自查单位")
	private String checkUnit;
	/**
	* 应查数量
	*/
	@ApiModelProperty(value = "应查数量")
	private Integer checkingCount;
	/**
	* 实查数量
	*/
	@ApiModelProperty(value = "实查数量")
	private Integer checkedCount;
	/**
	* 自查结果
	*/
	@ApiModelProperty(value = "自查结果")
	private String checkResult;
	/**
	* 自查详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增
	*/
	@ApiModelProperty(value = "自查详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
	private String checkDetail;
	/**
	* 自查状态(0:待审核,1:审核失败,2:自查完成)
	*/
	@ApiModelProperty(value = "自查状态(0:待审核,1:审核失败,2:自查完成)")
	private Integer checkStatus;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	 * 创建单位id
	 */
	@CreatedBy
	@ApiModelProperty(value = "创建单位id")
	private Integer createUnitId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;
	/**
	 * 自查未入库新增装备详情(RFID卡号以.为分隔符)
	 */
	@ApiModelProperty(value = "自查未入库新增装备详情(RFID卡号以.为分隔符)")
	private String newDeviceDetail;

	@ApiModelProperty(value = "检查人")
	@Transient
	private String checkUser;

	@ApiModelProperty(value = "确认人")
	@Transient
	private String confirmUser;

	@ApiModelProperty(value = "创建人")
	@Transient
	private String createUser;

	@ApiModelProperty(value = "创建单位")
	@Transient
	private String createUnit;

}
