package com.tykj.dev.device.storage.subject.vo;

import com.tykj.dev.device.library.subject.vo.DeviceLibrarySaveVo;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("入库存储类")
public class StorageBillSaveVo {
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "配送单位")
    private String sendUnit;

    @ApiModelProperty(value = "发件方")
    private String sendUserId;

    @ApiModelProperty(value = "配发时间")
    private Date sendTime;

    @ApiModelProperty(value = "接收单位A岗")
    private Integer receiveUserAId;

    @ApiModelProperty(value = "接收单位B岗")
    private Integer receiveUserBId;

    @ApiModelProperty(value = "配发单附件名")
    private String fileName;

    @ApiModelProperty(value = "配发单附件url")
    private String fileUrl;

    @ApiModelProperty(value = "入库单附件名")
    private String receiveFileName;

    @ApiModelProperty(value = "入库单附件url")
    private String receiveFileUrl;

    @ApiModelProperty(value = "待入库数量")
    private Integer storagingCount;

    @ApiModelProperty(value = "已入库数量")
    private Integer storagedCount;

    @ApiModelProperty(value = "入库各装备详情")
    private List<DeviceLibrarySaveVo> deviceLibrarySaveVoList;

    public StorageBill toDo(){
        StorageBill storageBillEntity = new StorageBill();
        BeanUtils.copyProperties(this,storageBillEntity);
        storageBillEntity.setStorageStatus(0);
        storageBillEntity.setStorageDetail("x");
        return storageBillEntity;
    }
}
