package com.tykj.dev.device.user.subject.service;


import com.tykj.dev.device.user.subject.entity.RolePermissions;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RolePermissionsService.java
 * @Description 角色权限关联逻辑层
 * @createTime 2020年07月29日 08:57:00
 */
public interface RolePermissionsService extends PublicService<RolePermissions>{
    /**
     * 根据角色id集合查询所有权限角色对象
     * @param roleIds 角色id集合
     * @return  角色权限关联对象集合
     */
    List<RolePermissions> findAllByRoleIds(List<Integer> roleIds);

    /**
     * 根据角色id集合查询所有权限角色对象
     * @param roleId 角色id
     * @return 角色权限关联对象集合
     */
    List<RolePermissions> findAllByRoleId(Integer roleId);

    /**
     * 根据权限id查询角色权限对象
     * @param permissionsId 权限对象
     * @return 权限角色对象
     */
    List<RolePermissions> findAllByPermissionsId(Integer permissionsId);


    void deleteFindRoleId(Integer roleId);
}
