package com.tykj.dev.rfid.entity.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for library_warning_log_detail
 * 库房告警详情
 * @author huangxiahao
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update library_warning_log_detail set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("库房告警详情")
public class LibraryWarningLogDetail {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id ;
	/**
	* 告警日志ID
	*/
	@ApiModelProperty(value = "告警日志ID")
	private Integer libraryWarningLogId ;

	/**
	 * 装备ID
	 */
	@ApiModelProperty(value = "装备ID")
	private Integer deviceId ;
	/**
	* 0为正常 1为异常
	*/
	@ApiModelProperty(value = "0为正常 1为异常")
	private Integer status ;
	/**
	* 是否处理 0为否 1为是
	*/
	@ApiModelProperty(value = "是否处理 0为否 1为是")
	private Integer warningHandle ;
	/**
	* 处理结果
	*/
	@ApiModelProperty(value = "处理结果")
	private String handleResult ;
	/**
	* 异常情况
	*/
	@ApiModelProperty(value = "异常情况")
	private String inventoryResults ;
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId = 0;
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime ;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId = 0;
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime ;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag  = 0 ;
}
