package com.tykj.dev.device.user.base.ret;

import com.tykj.dev.device.user.base.beabs.BeanHelper;
import com.tykj.dev.device.user.subject.entity.Role;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AddRole.java
 * @Description TODO
 * @createTime 2020年08月12日 12:21:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "角色添加修改对象对象", description = "角色添加修改对象对象")
public class RoleVo {
    @ApiModelProperty(value = "角色id", name = "roleId", example = "12321L")
    private Integer roleId;

    @ApiModelProperty(value = "角色名称", name = "roleName", example = "12321L")
    private String roleName;

    @ApiModelProperty(value = "创建人名称")
    private String createName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "权限id")
    List<Integer> permissionsIds;

    public Role toDo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,Role.class);
    }
}
