package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Permissions.java
 * @Description 权限对象
 * @createTime 2020年07月27日 11:29:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "权限对象", description = "权限详细信息")
public class Permissions {
    /**
     * 权限id
     */
    @Id
    @ApiModelProperty(value = "数据ID", name = "permissionsId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer permissionsId;

    /**
     * 权限描述
     */
    @ApiModelProperty(value = "权限描述", name = "permissionsDes", example = "12321L")
    private String permissionsDes;

    /**
     * 权限url
     */
    @ApiModelProperty(value = "权限地址",name = "url")
    private String url;

    /**
     * 权限类型 1.业务 2.装备 3.检查 4.专管员 5.rfid 6.统计分析 7.系统管理
     */
    @ApiModelProperty(value = "权限类型",name = "1")
    private Integer type;
}
