package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Role.java
 * @Description 角色对象
 * @createTime 2020年07月27日 11:24:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "角色对象", description = "角色详细信息")
public class Role {
    @Id
    @ApiModelProperty(value = "数据ID", name = "roleId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer roleId;

    @ApiModelProperty(value = "角色名称", name = "roleName", example = "12321L")
    private String roleName;

    @ApiModelProperty(value = "创建人名称")
    private String createName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @Transient
    @ApiModelProperty(value = "权限列表")
    List<Permissions> permissions;
}
