package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for train
 * 专管员培训
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("专管员培训")
@Table(name = "train",schema = "train")
public class Train {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	@ApiModelProperty(value = "主键")
	private Integer id;
	/**
	* 培训主题
	*/
	@Column(name = "theme",columnDefinition = "null  varchar(255) 培训主题")
	@ApiModelProperty(value = "培训主题")
	private String theme;
	/**
	* 地点
	*/
	@Column(name = "address",columnDefinition = "null  varchar(255) 地点")
	@ApiModelProperty(value = "地点")
	private String address;
	/**
	* 主办方
	*/
	@Column(name = "host",columnDefinition = "null  varchar(100) 主办方")
	@ApiModelProperty(value = "主办方")
	private String host;
	/**
	* 培训开始时间
	*/
	@Column(name = "start_time",columnDefinition = "null  datetime 培训开始时间")
	@ApiModelProperty(value = "培训开始时间")
	private Date startTime;
	/**
	* 培训结束时间
	*/
	@Column(name = "end_time",columnDefinition = "null  datetime 培训结束时间")
	@ApiModelProperty(value = "培训结束时间")
	private Date endTime;
	/**
	* 培训内容
	*/
	@Column(name = "content",columnDefinition = "null  varchar(1000) 培训内容")
	@ApiModelProperty(value = "培训内容")
	private String content;
	/**
	* 通知单位
	*/
	@Column(name = "notice_org",columnDefinition = "null  varchar(1000) 通知单位")
	@ApiModelProperty(value = "通知单位")
	private String noticeOrg;
	/**
	* 培训状态：1.报名中 2.截止报名 3.结束 4.撤销
	*/
	@Column(name = "status",columnDefinition = "null  tinyint(1) unsigned 培训状态：1.报名中 2.截止报名 3.结束 4.撤销")
	@ApiModelProperty(value = "培训状态：1.报名中 2.截止报名 3.结束 4.撤销")
	private Boolean status;
	/**
	* 创建用户
	*/
	@Column(name = "createuser",columnDefinition = "null  varchar(32) 创建用户")
	@ApiModelProperty(value = "创建用户")
	private String createuser;
	/**
	* 创建单位
	*/
	@Column(name = "create_org",columnDefinition = "null  varchar(32) 创建单位")
	@ApiModelProperty(value = "创建单位")
	private String createOrg;
	/**
	* 创建时间
	*/
	@Column(name = "createtime",columnDefinition = "null  datetime 创建时间")
	@ApiModelProperty(value = "创建时间")
	private java.sql.Timestamp createtime;
	/**
	* 更新用户
	*/
	@Column(name = "updateuser",columnDefinition = "null  varchar(32) 更新用户")
	@ApiModelProperty(value = "更新用户")
	private String updateuser;
	/**
	* 更新时间
	*/
	@Column(name = "updatetime",columnDefinition = "null  datetime 更新时间")
	@ApiModelProperty(value = "更新时间")
	private java.sql.Timestamp updatetime;
	/**
	* 合格分数
	*/
	@Column(name = "passScore",columnDefinition = "null  double 合格分数")
	@ApiModelProperty(value = "合格分数")
	private Double passScore;
	/**
	* 考试附件
	*/
	@Column(name = "examFile",columnDefinition = "null  varchar(1000) 考试附件")
	@ApiModelProperty(value = "考试附件")
	private String examFile;

}
