package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for train_enroll
 * 培训报名表
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("培训报名表")
@Table(name = "train_enroll",schema = "train_enroll")
public class TrainEnroll {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	@ApiModelProperty(name = "主键")
	private Integer id;
	/**
	* 培训id
	*/
	@Column(name = "train_id",columnDefinition = "not null  int(11) 培训id")
	@ApiModelProperty(name = "培训id")
	private Integer trainId;
	/**
	* 培训主办方
	*/
	@Column(name = "host",columnDefinition = "null  varchar(100) 培训主办方")
	@ApiModelProperty(name = "培训主办方")
	private String host;
	/**
	* 培训主题
	*/
	@Column(name = "theme",columnDefinition = "null  varchar(255) 培训主题")
	@ApiModelProperty(name = "培训主题")
	private String theme;
	/**
	* 专管员id
	*/
	@Column(name = "vmanager_id",columnDefinition = "not null  varchar(32) 专管员id")
	@ApiModelProperty(name = "专管员id")
	private String vmanagerId;
	/**
	* 专管员姓名
	*/
	@Column(name = "vmanager_name",columnDefinition = "not null  varchar(500) 专管员姓名")
	@ApiModelProperty(name = "专管员姓名")
	private String vmanagerName;
	/**
	* 所在组织
	*/
	@Column(name = "ownsup",columnDefinition = "not null  varchar(32) 所在组织")
	@ApiModelProperty(name = "所在组织")
	private String ownsup;
	/**
	* 所属组织名称
	*/
	@Column(name = "ownsup_name",columnDefinition = "not null  varchar(500) 所属组织名称")
	@ApiModelProperty(name = "所属组织名称")
	private String ownsupName;
	/**
	* 状态:1.任务未读 2.已报名 3.忽略报名 4.参加考试 5.缺席考试
	*/
	@Column(name = "status",columnDefinition = "not null  tinyint(1) unsigned 状态:1.任务未读 2.已报名 3.忽略报名 4.参加考试 5.缺席考试")
	@ApiModelProperty(name = "状态:1.任务未读 2.已报名 3.忽略报名 4.参加考试 5.缺席考试")
	private Boolean status;
	/**
	* 报名时间
	*/
	@Column(name = "enroll_time",columnDefinition = "null  datetime 报名时间")
	@ApiModelProperty(name = "报名时间")
	private Date enrollTime;
	/**
	* 得分
	*/
	@Column(name = "score",columnDefinition = "null  double(6,2) 得分")
	@ApiModelProperty(name = "得分")
	private Double score;

}
