package com.tykj.dev.device.user.subject.entity;

import com.tykj.dev.device.user.base.beabs.BeanHelper;
import com.tykj.dev.device.user.base.ret.UnitsTrainVo;
import com.tykj.dev.device.user.base.ret.UnitsVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Units.java
 * @Description 单位对象
 * @createTime 2020年07月28日 09:23:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "单位对象", description = "单位详细信息")
public class Units {
    /**
     * 单位id
     */
    @Id
    @ApiModelProperty(value = "单位id", name = "unitId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer unitId;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", name = "unitName", example = "12321L")
    private String name;

    /**
     * 单位描述
     */
    @ApiModelProperty(value = "单位描述", name = "unitDesc", example = "12321L")
    private String unitDesc;

    /**
     * 等级
     */
    @ApiModelProperty(value = "等级", name = "level", example = "12321L")
    private Integer level;

    /**
     * 是否删除
     */
    @ApiModelProperty(value = "是否删除", name = "idDel", example = "12321L")
    private Integer idDel;

    /**
     * 序列号
     */
    @ApiModelProperty(value = "序列号", name = "code", example = "12321L")
    private String code;

    /**
     * 区域id
     */
    @ApiModelProperty(value = "区域id", name = "areaId", example = "12321L")
    private Integer areaId;

    /**
     * 区域对象
     */
    @Transient
    private Area area;

    public static Units toDb(){
        return new Units(
                null,
                "省机要局",
                "秘密测试",
                1,
                0,
                "1234",
                1,
                null
        );
    }

    public UnitsVo toVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, UnitsVo.class);
    }
    public UnitsTrainVo toUnitsTrainVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, UnitsTrainVo.class);
    }
}
