/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UsbUtils {
    private static final List<String> cardCmdIdValues = new ArrayList<String>(Arrays.asList("zmotif", "epcl", "epcl1", "epcl3"));

    public static void addSymbolicNameAttributesToMap(String string, Map<String, String> map) {
        String string2 = UsbUtils.getSerialNumberFromSymbolicName(string);
        String string3 = UsbUtils.getProductId(string);
        map.put("SERIAL_NUMBER", string2);
        map.put("ADDRESS", string);
        map.put("pid", string3);
        map.put("vid", UsbUtils.getVendorId(string));
    }

    private static String getSerialNumberFromSymbolicName(String string) {
        String string2 = "";
        int n = string.indexOf("#", 8);
        int n2 = string.indexOf("#", n + 1);
        if (n > -1 && n2 > 0) {
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    private static String getProductId(String string) {
        String string2 = "";
        int n = string.indexOf("pid_");
        if (n != -1) {
            string2 = string.substring(n += 4, n + 4);
        }
        return string2;
    }

    protected static String getVendorId(String string) {
        String string2 = "";
        int n = string.indexOf("vid_");
        if (n != -1) {
            string2 = string.substring(n += 4, n + 4);
        }
        return string2;
    }

    public static void addDeviceIdArtributesToMap(Map<String, String> map, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length <= 1) continue;
            String string3 = stringArray2[0];
            String string4 = stringArray2[1].trim();
            if (string3.equals("MANUFACTURER")) {
                map.put("MFG", string4);
            }
            if (string3.equals("MFG")) {
                map.put("MFG", string4);
            }
            if (string3.equals("MODEL")) {
                map.put("MODEL", string4);
            }
            if (string3.equals("MDL")) {
                map.put("MODEL", string4);
            }
            if (string3.equals("COMMAND SET")) {
                map.put("CMD", string4);
            }
            if (string3.equals("CMD")) {
                map.put("CMD", string4);
            }
            if (string3.equals("SERIAL NUMBER")) {
                map.put("SERIAL_NUMBER", string4);
            }
            if (!string3.equals("SN")) continue;
            map.put("SERIAL_NUMBER", string4);
        }
    }

    public static boolean isCardPrinter(Map<String, String> map) {
        String string;
        boolean bl = false;
        String string2 = "";
        if (map.containsKey("CMD")) {
            string2 = map.get("CMD");
        }
        if (map.containsKey("MFG") && ((string = map.get("MFG").toLowerCase(Locale.US)).contains("card") || UsbUtils.isCardPrinterCmdId(string2))) {
            bl = true;
        }
        return bl;
    }

    private static boolean isCardPrinterCmdId(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty() && cardCmdIdValues.contains(string.toLowerCase(Locale.US))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isZMotifPrinter(Map<String, String> map) {
        String string;
        boolean bl = false;
        String string2 = "";
        if (map.containsKey("CMD")) {
            string2 = map.get("CMD");
        }
        if (map.containsKey("MFG") && ((string = map.get("MFG")).trim().equalsIgnoreCase("zebra digital card printer") || string2.equalsIgnoreCase("zmotif"))) {
            bl = true;
        }
        return bl;
    }

    public static String decodeZmotifSerialNumber(String string) {
        int n;
        int n2;
        String string2 = "";
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        String string3 = "";
        for (n2 = 31; n2 >= 25; --n2) {
            string3 = string3.concat(Integer.toBinaryString(n3 >> n2 & 1));
        }
        switch (Integer.parseInt(string3, 2)) {
            case 1: {
                string2 = "06A";
                break;
            }
            case 2: {
                string2 = "06C";
                break;
            }
            case 3: {
                string2 = "06J";
                break;
            }
            case 4: {
                string2 = "10A";
                break;
            }
            case 5: {
                string2 = "10C";
                break;
            }
            case 6: {
                string2 = "10J";
                break;
            }
            case 7: {
                string2 = "12A";
                break;
            }
            case 8: {
                string2 = "12C";
                break;
            }
            case 9: {
                string2 = "12J";
                break;
            }
            case 10: {
                string2 = "Z9J";
                break;
            }
            case 11: {
                string2 = "C1J";
                break;
            }
            case 12: {
                string2 = "C3J";
                break;
            }
            default: {
                return string;
            }
        }
        string3 = "";
        for (n2 = 24; n2 >= 19; --n2) {
            string3 = string3.concat(Integer.toBinaryString(n3 >> n2 & 1));
        }
        n2 = Integer.parseInt(string3, 2);
        if (n2 < 10) {
            string2 = string2.concat("0");
        }
        string2 = string2.concat(Integer.toString(n2));
        string3 = "";
        for (n = 18; n >= 13; --n) {
            string3 = string3.concat(Integer.toBinaryString(n3 >> n & 1));
        }
        n2 = Integer.parseInt(string3, 2);
        if (n2 < 10) {
            string2 = string2.concat("0");
        }
        string2 = string2.concat(Integer.toString(n2));
        string3 = "";
        for (n = 12; n >= 0; --n) {
            string3 = string3.concat(Integer.toBinaryString(n3 >> n & 1));
        }
        n2 = Integer.parseInt(string3, 2);
        string2 = string2.concat("0");
        String string4 = Integer.toString(n2);
        for (int i = string4.length(); i < 4; ++i) {
            string2 = string2.concat("0");
        }
        string2 = string2.concat(string4);
        return string2;
    }
}

