package com.tykj.dev.device.allot.subject.domin;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update allot_back_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配发退回账单")
public class AllotBackBill {

    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "退回标题")
    private String title;

    @ApiModelProperty(name = "配发单主键id")
    private Integer allotBillId;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;

    @ApiModelProperty(value = "发件签发人")
    private String agent;

    @ApiModelProperty(value = "配发时间")
    private Date sendTime;
    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    private Date receiveTime;

    @ApiModelProperty(value = "发件经办人id(A岗位)")
    private Integer sendUseraId;

    @ApiModelProperty(value = "发件方审核人id(B岗位)")
    private Integer sendUserbId;

    @ApiModelProperty(value = "收件经办人id(A岗位)")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "收件方审核人id(B岗位)")
    private Integer receiveUserbId;

    @ApiModelProperty(value = "出库附件文件名")
    private String fileName;

    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl;

    @ApiModelProperty(value = "入库附件文件名")
    private String receiveFileName;

    @Column(name = "receive_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "入库附件文件地址URL")
    private String receiveFileUrl;

    @ApiModelProperty(value = "账单文件名")
    private String billFileName;

    @Column(name = "bill_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "账单文件地址URL")
    private String billFileUrl;

    @ApiModelProperty(value = "配发退回状态(0:退回中，1:草稿，2:退回接收审核失败，3:退回完成)")
    private Integer backStatus;

    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;

    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;

    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "退回装备数量")
    private Integer backCount;

    @ApiModelProperty(value = "已配发出库装备数量")
    private Integer backedCount;

    @ApiModelProperty(value = "已接收装备数量")
    private Integer receiveCount;

    @Column(name = "back_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "退回出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String backCheckDetail;

    @ApiModelProperty(value = "退回出库检查结果")
    private String backCheckResult;

    @Column(name = "receive_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "退回接收方检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String receiveCheckDetail;

    @ApiModelProperty(value = "接收方检查结果")
    private String receiveCheckResult;

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "发件经办人")
    @Transient
    private String senderUserA;

    @ApiModelProperty(value = "收件经办人")
    @Transient
    private String receiveUserA;

    @ApiModelProperty(value = "收件方审核人")
    @Transient
    private String receiveUserB;

    @ApiModelProperty(value = "发件方审核人")
    @Transient
    private String senderUserB;

    @ApiModelProperty(value = "退回单号")
    private String num;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @ApiModelProperty(value = "批复文号文件")
    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @ApiModelProperty(value = "发件方回执单")
    @Column(name = "send_files",columnDefinition = "TEXT")
    private String sendFiles;

    @ApiModelProperty(value = "收件方签收单")
    @Column(name = "receive_files",columnDefinition = "TEXT")
    private String receiveFiles;

    @ApiModelProperty(value = "申请文号文件")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @ApiModelProperty(value = "单据集合json")
    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @ApiModelProperty(value = "单据集合")
    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @ApiModelProperty(value = "批复文号文件集合")
    @Transient
    private List<FileRet> replyFileList = new ArrayList<>();

    @ApiModelProperty(value = "发件方回执单集合")
    @Transient
    private List<FileRet> sendFileList = new ArrayList<>();

    @ApiModelProperty(value = "申请文号文件集合")
    @Transient
    private List<FileRet> applyFileList = new ArrayList<>();

    @ApiModelProperty(value = "收件方签收单集合")
    @Transient
    private List<FileRet> receiveFileList = new ArrayList<>();

    @ApiModelProperty(value = "装备集合")
    @Transient
    private List<DeviceLibrary> deviceLibraries;

    @ApiModelProperty("任务id")
    @Transient
    private Integer taskId;
}
