package com.tykj.dev.device.apply.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("申请审核类")
public class DeviceApplyConfirmVo {
    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "对应任务ID", example = "1")
    private Integer taskId;

    @NotNull(message = "status不能为空")
    @Min(value = 0,message = "status不能小于0")
    @ApiModelProperty(name = "需要修改的状态", example = "0", value = "0为审核通过,1为驳回")
    private Integer status;

    @ApiModelProperty(value = "批复文号")
    private String replyNumber;
}
