package com.tykj.dev.device.apply.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("申请上传回执单类")
public class UploadApplyFile {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "对应任务ID", example = "1")
    private Integer taskId;

    @ApiModelProperty(value = "申请回执单附件")
    private List<FileRet> backFiles;

    @ApiModelProperty(value = "申请批复装备")
    private List<ReplyVo> replyVos;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    
    @ApiModelProperty(value = "批复文号附件名")
    private List<FileRet> replyFiles;

    @ApiModelProperty(value = "申请批复详情")
    private List<ApplyBillDetailVo> applyBillDetailVos;

    @ApiModelProperty(value = "申请批复结果（0：未通过，1：通过）")
    private Integer status;

}
