package com.tykj.dev.config;

import lombok.AllArgsConstructor;

import static com.tykj.dev.misc.base.BusinessEnum.*;
import static com.tykj.dev.misc.base.StatusEnum.*;

/**
 * @author dengdiyi
 */
@AllArgsConstructor
public enum LogType {
    /**
     * 发起列装
     */
    PACKING_1(1,PACKING.id,ORIGIN_STATUS.id, PACKING_CONFIRM.id, "发起列装"),
    /**
     * 列装审核成功
     */
    PACKING_2(2,PACKING.id, PACKING_CONFIRM.id, END.id, "列装审核成功"),
    /**
     * 列装审核失败
     */
    PACKING_3(3,PACKING.id, PACKING_CONFIRM.id, ARCHIVE.id, "列装审核失败"),

    STORAGE_1(4,STORAGE.id, ORIGIN_STATUS.id, END.id, "发起装备入库"),

    STORAGE_2(5,STORAGE.id, WAIT_STORAGE.id, END.id, "发起装备入库"),

    STORAGE_3(6,STORAGE.id, ORIGIN_STATUS.id, WAIT_STORAGE.id, "保存入库草稿"),

    ALLOT_1(7,ALLOT.id, ALLOT_DRAFT.id, ALLOTING.id, "对(%receiveUnit)发起配发"),

//    ALLOT_2(8,ALLOT.id, ORIGIN_STATUS.id, ALLOT_DRAFT.id, "保存配发草稿"),
    ALLOT_2(8,ALLOT.id, ORIGIN_STATUS.id, ALLOT_DRAFT.id, "保存配发草稿"),

    ALLOT_3(9,ALLOT.id, ALLOT_DRAFT.id, ARCHIVE.id, "删除配发草稿"),

    ALLOT_4(10,ALLOT.id, WAIT_UPLOAD_ALLOT_FILE.id, END.id, "上传配发回执单"),

    ALLOT_5(11,ALLOT.id, WAIT_UPLOAD_ALLOT_FILE.id, ARCHIVE.id, "取消上传配发单"),

    ALLOT_6(12,ALLOT.id, ORIGIN_STATUS.id, WAIT_UPLOAD_CROSS_FILE.id, "对(%receiveUnit)发起配发"),

    ALLOT_7(13,ALLOT.id, WAIT_UPLOAD_CROSS_FILE.id, END.id, "上传配发回执单"),

    RFID_1(14,TAG.id, ORIGIN_STATUS.id, RFID_BUSINESS_NEED_CONFIRM.id, "发起标签替换"),

    RFID_2(15,TAG.id, RFID_BUSINESS_NEED_CONFIRM.id, END.id, "标签替换审核成功"),

    RFID_3(16,TAG.id, RFID_BUSINESS_NEED_CONFIRM.id, ARCHIVE.id, "标签替换审核失败"),

    SELF_CHECK_1(17,SELF_CHECK.id, ORIGIN_STATUS.id, SELF_CHECK_CONFIRM.id, "发起自查"),

    SELF_CHECK_2(18,SELF_CHECK.id, WAIT_SELF_CHECK.id, SELF_CHECK_CONFIRM.id, "发起自查"),

    SELF_CHECK_3(19,SELF_CHECK.id, SELF_CHECK_CONFIRM.id, END.id, "上传自查单"),

    SELF_CHECK_4(20,SELF_CHECK.id, SELF_CHECK_CONFIRM.id, ARCHIVE.id, "自查审核失败"),

    APPLY_1(21,APPLY.id, ORIGIN_STATUS.id, DEVICE_APPLY_CONFIRM.id, "发起装备申请"),

    APPLY_2(22,APPLY.id, DEVICE_APPLY_CONFIRM.id, END.id, "装备申请批复通过"),

    APPLY_3(23,APPLY.id, DEVICE_APPLY_CONFIRM.id, ARCHIVE.id, "装备申请批复驳回"),


    MATCHING_1(27,ADD_MATCHING_DEVICE.id, ORIGIN_STATUS.id, END.id, "发起新增配套设备"),

    MATCHING_2(28,ADD_MATCHING_DEVICE.id, ADD_MATCHING_DEVICE_CONFIRM.id, END.id, "添加配套设备审核成功"),

    MATCHING_3(29,ADD_MATCHING_DEVICE.id, ADD_MATCHING_DEVICE_CONFIRM.id, ARCHIVE.id, "添加配套设备审核失败"),

    REPAIR_SEND_1(30,REPAIR.id, ORIGIN_STATUS.id, WAIT_RECEIVE.id, "向(%receiveUnit)发起装备维修"),

    REPAIR_SEND_2(31,REPAIR.id, REPAIR_SEND_CONFIRM.id, WAIT_RECEIVE.id, "审核成功并出库"),


    REPAIR_SEND_3(32,REPAIR.id, REPAIR_SEND_CONFIRM.id, ARCHIVE.id, "维修出库审核失败"),

    REPAIR_SEND_4(33,REPAIR.id, WAIT_RECEIVE.id, END.id, "上传相关单据，任务结束"),//

    REPAIR_SEND_5(34,REPAIR.id, WAIT_RECEIVE.id, WAIT_UPLOAD_FILE.id, "接收维修装备并发起入库(缺少单据)"),

    REPAIR_SEND_6(35,REPAIR.id, WAIT_UPLOAD_FILE.id, END.id, "上传送修单据"),

    REPAIR_SEND_7(36,REPAIR.id, REPAIR_SEND_CONFIRM.id, COUNTRY_REPAIRING.id, "审核成功并出库"),

    REPAIR_BACK_1(37,REPAIR_BACK.id, ORIGIN_STATUS.id, WAIT_BACK_RECEIVE.id, "向(%receiveUnit)退还维修装备"),

    REPAIR_BACK_2(38,REPAIR_BACK.id, WAIT_BACK_RECEIVE.id, WAIT_UPLOAD_BACK_FILE.id, "维修退回装备接收并发起入库(缺失单据)"),

    REPAIR_BACK_3(39,REPAIR_BACK.id, WAIT_UPLOAD_BACK_FILE.id, END.id, "上传相关单据，任务完成"),

    REPAIR_BACK_4(40,REPAIR_BACK.id, WAIT_BACK_RECEIVE.id, END.id, "维修退回装备接收并发起入库"),

    REPAIR_BACK_5(41,REPAIR_BACK.id, ORIGIN_STATUS.id, WAIT_UPLOAD_BACK_FILE.id, "维修退回装备接收并发起入库(缺失单据)"),

    REPAIR_BACK_6(42,REPAIR_BACK.id, WAIT_UPLOAD_BACK_SEND_FILE.id, ARCHIVE.id, "取消上传领取单"),

    RETIRED_1(43,RETIRED.id, ORIGIN_STATUS.id, END.id, "发起退装"),

    RETIRED_2(44,RETIRED.id,RETIRED_BUSINESS_NEED_CONFIRM.id, END.id, "退装审核成功"),

    RETIRED_3(45,RETIRED.id, RETIRED_BUSINESS_NEED_CONFIRM.id, ARCHIVE.id, "退装审核失败"),

    TRAIN_1(46,TRAIN.id, ORIGIN_STATUS.id, TRAIN1000.id, "发起培训"),

    CONFIRM_CHECK_DETAIL_NORMAL_0(401,CONFIRM_CHECK_DETAIL.id, ORIGIN_STATUS.id, CHECK_DETAIL_REGION_0.id, "核查详情任务开始"),

    CONFIRM_CHECK_DETAIL_NORMAL_1(402,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_0.id, CHECK_DETAIL_REGION_1.id, "A岗核查成功,等待专管员B操作"),

    CONFIRM_CHECK_DETAIL_NORMAL_2(403,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_1.id, CHECK_DETAIL_REGION_2.id, "B岗核查成功,等待核查组成员A审核"),

    CONFIRM_CHECK_DETAIL_NORMAL_3(404,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_2.id, END.id, "市专管员审核成功，该自查任务完结"),

    CONFIRM_CHECK_DETAIL_OTHER_1(406,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_1.id, END.id, "B岗核查成功,该任务没有核查组成员,任务结束,上传数据到统计信息"),

    CONFIRM_CHECK_DETAIL_OTHER_2(407,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_1.id, CHECK_DETAIL_REGION_0.id, "B岗审核失败,跳回区A岗人员操作"),

    CONFIRM_CHECK_DETAIL_OTHER_3(408,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_2.id, CHECK_DETAIL_REGION_0.id, "市专管员审核失败,跳回区A岗人员操作"),

    CONFIRM_CHECK_DETAIL_STAT_0(410,CONFIRM_CHECK_STAT.id, ORIGIN_STATUS.id, CHECK_STAT_0.id, "核查统计任务开始"),

    CONFIRM_CHECK_DETAIL_STAT_1(411,CONFIRM_CHECK_STAT.id, CHECK_STAT_0.id, CHECK_STAT_1.id, "地区数据已统计完毕,等待确认"),

    CONFIRM_CHECK_DETAIL_STAT_2(412,CONFIRM_CHECK_STAT.id, CHECK_STAT_1.id, END.id, "地区数据已确认完毕,将统计上传,任务完结"),

    CONFIRM_CHECK_EXAM_STAT_0(413, CONFIRM_CHECK_STAT.id, ORIGIN_STATUS.id, CHECK_EXAM_STAT_0.id, "检查统计任务开始"),

    CONFIRM_CHECK_EXAM_STAT_1(414, CONFIRM_CHECK_STAT.id, CHECK_EXAM_STAT_0.id, CHECK_EXAM_STAT_1.id, "检查统计数据已统计完毕,等待确认"),

    CONFIRM_CHECK_EXAM_STAT_2(415, CONFIRM_CHECK_STAT.id, CHECK_EXAM_STAT_1.id, END.id, "检查统计任务数据已确认完毕，任务完结"),

    CONFIRM_CHECK_EXAM_DETAIL_0(416, CONFIRM_CHECK_DETAIL.id, ORIGIN_STATUS.id, CHECK_DETAIL_REGION_0.id, "检查详情任务开始"),

    CONFIRM_CHECK_EXAM_DETAIL_1(417, CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_0.id, CHECK_DETAIL_REGION_1.id, "A岗核查成功,等待专管员B操作"),

    CONFIRM_CHECK_EXAM_DETAIL_2(418, CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_1.id, END.id, "专管员B核查成功,该地区的检查任务结束了"),

    CONFIRM_CHECK_EXAM_DETAIL_3(419, CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_REGION_1.id, CHECK_DETAIL_REGION_0.id, "B岗审核失败,跳回A岗人员操作"),

    CONFIRM_CHECK_EXAM_STAT_3(420, CONFIRM_CHECK_DETAIL.id, CHECK_EXAM_STAT_0.id, END.id, "检查统计任务数据已确认完毕，任务完结"),

    CONFIRM_CHECK_SELF_ROLLBACK(421, CONFIRM_CHECK_DETAIL.id,  END.id,CHECK_DETAIL_REGION_0.id, "自查任务已退回至等待专管员A处理状态"),

    CONFIRM_CHECK_EXAM_ROLLBACK(422, CONFIRM_CHECK_DETAIL.id,  END.id,CHECK_EXAM_STAT_1.id, "检查任务已退回至等待确认状态"),

    CONFIRM_CHECK_EXAM_CITY_DETAIL_0(423, CONFIRM_CHECK_DETAIL.id, ORIGIN_STATUS.id, CHECK_DETAIL_CITY_0.id, "检查详情任务开始"),

    CONFIRM_CHECK_EXAM_CITY_DETAIL_1(424, CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_CITY_0.id, CHECK_DETAIL_CITY_1.id, "专管员A操作成功,等待专管员B操作"),

    CONFIRM_CHECK_EXAM_CITY_DETAIL_REDO(425, CONFIRM_CHECK_DETAIL.id, END.id, CHECK_DETAIL_CITY_0.id, "检查详情任务开始重做"),

    CONFIRM_CHECK_EXAM_CITY_VERIFY_DONE(426, CONFIRM_CHECK_DETAIL.id, CONFIRM_STAT_0.id, END.id, "市统计数据确认完毕"),

    CONFIRM_CHECK_EXAM_CITY_DETAIL_DONE(427, CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_CITY_1.id, END.id, "专管员B处理完毕，任务结束"),

    CONFIRM_CHECK_EXAM_CITY_STAT_0(428, CONFIRM_CHECK_STAT.id, ORIGIN_STATUS.id, CHECK_STAT_1.id, "统计任务开始"),




    ALLOT_BACK_1(57, ALLOT_BACK.id, ORIGIN_STATUS.id, ALLOT_BACKING.id, "发起装备退回"),

    ALLOT_BACK_2(58,ALLOT_BACK.id, ALLOT_BACKING.id, END.id, "接收退回装备并上传相关单据"),

    ALLOT_BACK_3(59,ALLOT_BACK.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, END.id, "上传退回签收单"),

    ALLOT_BACK_4(60,ALLOT_BACK.id, ALLOT_BACKING.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, "退回装备接收成功(缺失单据)"),

    TRAIN1(61, TRAIN.id, ORIGIN_STATUS.id, TRAIN1000.id, "创建培训成功,等待报名"),
    TRAIN2(62, TRAIN.id, TRAIN1000.id, TRAIN1010.id, "报名结束,待培训"),
    TRAIN3(63, TRAIN.id, TRAIN1010.id, TRAIN1004.id, "培训中"),
    TRAIN4(64, TRAIN.id, TRAIN1004.id, TRAIN1005.id, "市培训成绩录入完成"),
    TRAIN5(65, TRAIN.id, TRAIN1005.id, TRAIN1006.id, "市向省申请发证"),
    TRAIN6(66, TRAIN.id, TRAIN1006.id, END.id, "市培训完成"),
    TRAIN7(67, TRAIN.id, TRAIN1004.id, TRAIN1007.id, "省培训成绩录入完成，等待审核"),
    TRAIN8(68, TRAIN.id, TRAIN1007.id, END.id, "省培训完成"),

    SEND_BACK_1(69,SEND_BACK_STATISTICAL.id, ORIGIN_STATUS.id, SEND_BACK_1200.id, "省发起清退任务,等待下属单位把需要清退到装备送至省单位"),
    SEND_BACK_2(70,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1201.id, "省发起对市发起清退任务"),
    SEND_BACK_3(71,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1202.id, "省发起省直属单位清退装备提交任务"),
    SEND_BACK_4(72,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1203.id, "省对着自己发起装备清退任务，清退自己单位对装备"),
    SEND_BACK_7(75,SEND_BACK_STATISTICAL.id, ORIGIN_STATUS.id, SEND_BACK_1204.id, "转发了省级清退任务，生成市对清退统计任务"),
    SEND_BACK_8(76,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1205.id, "市转发了省清退任务，对区县发起了清退任务"),
    SEND_BACK_9(77,SEND_BACK.id, SEND_BACK_1201.id, SEND_BACK_1206.id, "市等待下级单位提交清退装备，在选择装备库送至省里"),
    SEND_BACK_10(78,SEND_BACK.id, SEND_BACK_1205.id,SEND_BACK_1206.id , "区县根据清退通知，选择了需要清退对装备"),
    SEND_BACK_11(10001,SEND_BACK.id, SEND_BACK_1206.id,SEND_BACK_1207.id , "选择需要清退对装备，提交等待上级审核"),
    SEND_BACK_12(10002,SEND_BACK.id, SEND_BACK_1207.id,SEND_BACK_1208.id , "上级审核通过，可以进行出库，把装备送至上级"),
    SEND_BACK_13(10003,SEND_BACK.id, SEND_BACK_1208.id,SEND_BACK_1209.id , "清退装备已出库，等待单位接收"),
    SEND_BACK_14(10004,SEND_BACK.id, SEND_BACK_1209.id,END.id , "上传相关签字单据，任务完成"),
    SEND_BACK_15(10005,SEND_BACK.id, SEND_BACK_1207.id,SEND_BACK_1206.id , "上级审核不通过"),
    SEND_BACK_16(10006,SEND_BACK.id, SEND_BACK_1206.id,SEND_BACK_1208.id , "全部清退任务，不需要审核，等待清退装备出库"),
    SEND_BACK_19(10009,SEND_BACK.id, ORIGIN_STATUS.id,SEND_BACK_1211.id , "市发起清退任务，待省级单位审核"),
    SEND_BACK_20(100010,SEND_BACK.id, SEND_BACK_1211.id,END.id , "省对单位审核不通过，任务结束"),
    SEND_BACK_21(100011,SEND_BACK.id, SEND_BACK_1211.id,SEND_BACK_1204.id , "省对单位审核通过，等待下级单位提交"),
    SEND_BACK_23(100013,SEND_BACK.id, SEND_BACK_1212.id,END.id , "清退统计任务已办结"),
    SEND_BACK_24(100014,SEND_BACK_STATISTICAL.id, SEND_BACK_1204.id,SEND_BACK_1212.id , "市清退统计任务待办结"),
    SEND_BACK_25(100015,SEND_BACK_STATISTICAL.id, SEND_BACK_1200.id,SEND_BACK_1212.id , "省清退统计任务待办结"),
    SEND_BACK_26(100016,SEND_BACK.id, SEND_BACK_1214.id,END.id , "上传相关签字单据,任务弯沉"),
    SEND_BACK_27(100017,SEND_BACK.id, SEND_BACK_1202.id,SEND_BACK_1213.id , "省直属单位清退装备选择完成，等待签字单据上传"),
    SEND_BACK_28(100018,SEND_BACK.id, SEND_BACK_1213.id,END.id , "上传了直属单位清退签字单据"),
    SEND_BACK_29(100019,SEND_BACK.id, SEND_BACK_1209.id,SEND_BACK_1215.id , "签字单据未上传,继续等待相关单据上传"),
    SEND_BACK_30(100020,SEND_BACK.id, SEND_BACK_1208.id,SEND_BACK_1217.id , "调用电子签章，等待审核"),
    SEND_BACK_31(100021,SEND_BACK.id, SEND_BACK_1217.id,SEND_BACK_1219.id , "电子签章调用审核通过，等待盖章出库"),
    SEND_BACK_32(100022,SEND_BACK.id, SEND_BACK_1217.id,SEND_BACK_1208.id , "电子签章调用审核不通过，等待重新出库"),
    SEND_BACK_33(100023,SEND_BACK.id, SEND_BACK_1209.id,SEND_BACK_1220.id , "入库任务调用电子签章，等待审核"),
    SEND_BACK_34(100024,SEND_BACK.id, SEND_BACK_1220.id,SEND_BACK_1218.id , "入库任务调用电子签章审核通过，等待盖章入库"),
    SEND_BACK_35(100025,SEND_BACK.id, SEND_BACK_1220.id,SEND_BACK_1209.id , "入库任务调用电子签章审核不通过，等待重新入库"),
    SEND_BACK_36(100026,SEND_BACK.id, SEND_BACK_1207.id,END.id , "审核提交清退装备任务通过，本次任务无提交任何装备,任务结束"),
    SEND_BACK_37(100027,SEND_BACK.id, SEND_BACK_1205.id,END.id , "本次提交任务无装备,任务结束"),
    SEND_BACK_38(100028,SEND_BACK.id, SEND_BACK_1203.id,END.id , "本次提交任务无装备,任务结束"),
    SEND_BACK_39(100029,SEND_BACK.id, SEND_BACK_1206.id,END.id , "本次提交任务无装备,任务结束"),
    SEND_BACK_40(100030,SEND_BACK.id, SEND_BACK_1208.id,END.id , "本次提交任务无装备,任务结束"),
    SEND_BACK_41(100031,SEND_BACK.id, SEND_BACK_1215.id,END.id , "清退装备任务,上传了签收单据,任务结束"),
    SEND_BACK_42(100032,SEND_BACK.id, SEND_BACK_1218.id,END.id , "使用签章或上传相关单据,清退装备任务结束"),
    SEND_BACK_43(100033,SEND_BACK.id, SEND_BACK_1219.id,SEND_BACK_1209.id , "使用电子盖章出库，等待发往单位接收入库"),
//SEND_BACK_13(10003,SEND_BACK.id, SEND_BACK_1208.id,SEND_BACK_1209.id , "清退装备已出库，等待单位接收"),



    //退役
    DECOMMISSIONING_1(100201,DECOMMISSIONING.id, ORIGIN_STATUS.id,SEND_BACK_1210.id , "发起退役任务，等待中办签字单据"),
    DECOMMISSIONING_2(100202,DECOMMISSIONING.id, SEND_BACK_1210.id,END.id , "上传中办签字单据，任务结束"),
    DECOMMISSIONING_3(100203,DECOMMISSIONING.id, ORIGIN_STATUS.id,DECOMMISSIONING_1250.id , "发起了退役任务的草稿"),
    DECOMMISSIONING_4(100204,DECOMMISSIONING.id, DECOMMISSIONING_1250.id,SEND_BACK_1210.id , "退役出库完成,等待上传退役签收单"),
    DECOMMISSIONING_5(100205,DECOMMISSIONING.id, SEND_BACK_1210.id,END.id , "上传中办签字单据，任务结束"),
    DECOMMISSIONING_6(100206,DECOMMISSIONING.id, ORIGIN_STATUS.id,DECOMMISSIONING_1251.id , "发起退役任务，等待待用签章审核"),
    DECOMMISSIONING_7(100207,DECOMMISSIONING.id, DECOMMISSIONING_1251.id,DECOMMISSIONING_1250.id , "调用电子签章审核,拒绝"),
    DECOMMISSIONING_8(100208,DECOMMISSIONING.id, DECOMMISSIONING_1251.id,DECOMMISSIONING_1252.id , "调用电子签章审核,通过"),
    DECOMMISSIONING_9(100209,DECOMMISSIONING.id, DECOMMISSIONING_1252.id,END.id , "上传中办签字单据，任务结束"),
    DECOMMISSIONING_10(100210,DESTROY.id, DECOMMISSIONING_1250.id,DECOMMISSIONING_1251.id , "调用签章等待审核"),
//    DECOMMISSIONING_2(100202,DECOMMISSIONING.id, SEND_BACK_1210.id,END.id , "上传中办签字单据，任务结束"),


    //销毁任务日志
    DESTROY_LOG_1(100301,DESTROY.id, ORIGIN_STATUS.id, DESTROY_2.id, "发起装备销毁"),
    DESTROY_LOG_2(100302,DESTROY.id, DESTROY_2.id, END.id, "上传销毁单据,任务结束"),
    DESTROY_LOG_3(100303,DESTROY.id, ORIGIN_STATUS.id, DESTROY_0.id, "发起了销毁任务的草稿"),
    DESTROY_LOG_4(100304,DESTROY.id, DESTROY_0.id, DESTROY_2.id, "发起了销毁任务"),

    //重新入库
    AGAINSTORAGE_01(100901,AGAINSTORAGE.id, ORIGIN_STATUS.id,END.id , "发起了装备生命状态转换"),

    SCRAP_1(100101,SCRAP.id, ORIGIN_STATUS.id, SCRAP_2222.id, "发起装备报废"),
    SCRAP_2(100102,SCRAP.id, SCRAP_2222.id, END.id, "上传报废单据,任务结束"),
    SCRAP_3(100103,SCRAP.id, ORIGIN_STATUS.id, SCRAP_2223.id, "发起了报废任务的草稿"),
    SCRAP_4(100104,SCRAP.id, SCRAP_2223.id, SCRAP_2222.id, "报废草稿任务，发布生成"),
    SCRAP_5(100105,SCRAP.id, SCRAP_2222.id, END.id, "上传报废单据,任务结束"),
    SCRAP_6(100106,SCRAP.id, ORIGIN_STATUS.id, SCRAP_2224.id, "发起报废任务,等待待用签章审核"),
    SCRAP_7(100107,SCRAP.id, SCRAP_2224.id, SCRAP_2223.id, "调用电子签章审核,拒绝"),
    SCRAP_8(100108,SCRAP.id, SCRAP_2224.id, SCRAP_2225.id, "调用电子签章审核,通过"),
    SCRAP_9(100109,SCRAP.id, SCRAP_2225.id, END.id, "上传报废单据,任务结束"),
//    SCRAP_2(100101,SCRAP.id, SCRAP_2222.id, END.id, "上传报废单据,任务结束"),
//    SCRAP_2(100101,SCRAP.id, SCRAP_2222.id, END.id, "上传报废单据,任务结束"),


    LOSS_1(9000,LOSS.id,ORIGIN_STATUS.id,LOSS1300.id,"发起装备丢失上报"),
    LOSS_2(9001,LOSS.id,LOSS1300.id,LOSS1301.id,"确认了装备丢失"),
    LOSS_3(9002,LOSS.id,LOSS1300.id,END.id,"确认了装备丢失报告,报告任务结束"),
    LOSS_4(9003,LOSS.id,ORIGIN_STATUS.id,END.id,"省装备丢失报告发起记录"),
    LOSS_5(9004,LOSS.id,ORIGIN_STATUS.id,LOSS1301.id,"发起丢失装备上报"),
    LOSS_6(9005,LOSS.id,LOSS1301.id,END.id,"省确认了装备丢失报告,报告任务结束"),



    RETRIEVE_1(9010,RETRIEVE.id,ORIGIN_STATUS.id,RETRIEVE1400.id,"发起装备找回上报"),
    RETRIEVE_2(9011,RETRIEVE.id,RETRIEVE1400.id,RETRIEVE1401.id,"确认了装备找回上报"),
    RETRIEVE_3(9012,RETRIEVE.id,RETRIEVE1400.id,END.id,"确认了装备找回上报,找回任务结束"),
    RETRIEVE_4(9013,RETRIEVE.id,ORIGIN_STATUS.id,END.id,"省装备找回报告发起记录"),
    RETRIEVE_5(9014,RETRIEVE.id,ORIGIN_STATUS.id,RETRIEVE1401.id,"发起装备找回上报"),
    RETRIEVE_6(9015,RETRIEVE.id,RETRIEVE1401.id,END.id,"审核装备找回完成，查看找回结果"),
    RETRIEVE_7(9016,RETRIEVE.id,RETRIEVE1402.id,END.id,"找回装备任务市审核不通过，任务结束"),
    RETRIEVE_8(9017,RETRIEVE.id,RETRIEVE1403.id,END.id,"找回装备任务省审核不通过，任务结束"),

    WORK_H1(79, WORK_HANDOVER.id, ORIGIN_STATUS.id, WORKHANDOVER1011.id, "工作交接任务生成完成,等待上传交接单"),
    WORK_H2(80, WORK_HANDOVER.id, WORKHANDOVER1011.id, END.id, "工作交接完成"),
    ALLOT_8(82, ALLOT.id, ORIGIN_STATUS.id, ALLOTING.id, "对(%receiveUnit)发起配发"),
    ALLOT_9(83, ALLOT.id, ALLOTING.id, END.id, "上传了相关单据，任务完结"),
    ALLOT_10(84, ALLOT.id, WAIT_ALLOT.id, ALLOTING.id, "对(%receiveUnit)发起配发"),
    ALLOT_11(85, ALLOT.id, ALLOTING.id, ARCHIVE.id, "拒绝接收配发装备"),
//    ALLOT_11(85, ALLOT.id, ALLOTING.id, ARCHIVE.id, "(%sendUnit)撤回了配发业务"),
    ALLOT_BACK_5(86, ALLOT_BACK.id, WAIT_UPLOAD_BACK_FILE_2.id, END.id, "上传退回回执单"),
    REPAIR_SEND_10(87, REPAIR.id, ORIGIN_STATUS.id, WAIT_UPLOAD_FILE.id, "向(%receiveUnit)发起装备维修"),
    REPAIR_BACK_7(88, REPAIR_BACK.id, ORIGIN_STATUS.id, END.id, "维修退回装备接收并发起入库"),
    STORAGE_4(89, STORAGE.id, WAIT_STORAGE.id, ARCHIVE.id, "删除入库草稿"),
//
    SELF_CHECK_5(92,SELF_CHECK.id, ORIGIN_STATUS.id, END.id, "终端自查"),
    SELF_CHECK_6(93,SELF_CHECK.id, WAIT_SELF_CHECK.id, END.id, "周期自查"),
    APPLY_4(94,APPLY.id, ORIGIN_STATUS.id, WAIT_APPLY_FILE.id, "发起申请"),
    REPAIR_BACK_8(95,REPAIR_BACK.id, WAIT_UPLOAD_BACK_SEND_FILE.id, END.id, "上传领取单"),
    REPAIR_SEND_11(96, REPAIR.id, WAIT_UPLOAD_SEND_FILE.id, END.id, "上传送修单"),
    REPAIR_SEND_12(97, REPAIR.id, WAIT_UPLOAD_SEND_FILE.id, ARCHIVE.id, "取消上传送修单"),
    ALLOT_BACK_6(98, ALLOT_BACK.id, WAIT_UPLOAD_BACK_FILE_2.id, ARCHIVE.id, "取消上传退回单"),
    ALLOT_12(99, ALLOT.id, ALLOTING.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, "接收配发装备(缺失单据)"),
    ALLOT_13(101, ALLOT.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, END.id, "上传相关单据,任务完结"),
    ALLOT_14(102,ALLOT.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, ARCHIVE.id, "取消上传配发单"),
    ALLOT_BACK_7(103, ALLOT_BACK.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, ARCHIVE.id, "取消上传退回单"),
    REPAIR_SEND_13(104, REPAIR.id, WAIT_UPLOAD_FILE.id, ARCHIVE.id, "取消上传送修单"),
    REPAIR_BACK_9(105,REPAIR_BACK.id, WAIT_UPLOAD_BACK_FILE.id, ARCHIVE.id, "取消上传领取单"),
    APPLY_5(106,APPLY.id, WAIT_APPLY_FILE.id, WAIT_CONFIRM_APPLY_DEVICE.id, "上传批复单"),
    APPLY_6(107,APPLY.id, WAIT_CONFIRM_APPLY_DEVICE.id, END.id, "业务办结"),
    ALLOT_15(108, ALLOT.id, ORIGIN_STATUS.id, SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    ALLOT_16(109,ALLOT.id, ALLOT_DRAFT.id, SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    ALLOT_17(110,ALLOT.id, SIGN_WAIT_CONFIRM.id, ALLOT_DRAFT.id, "拒绝电子签章申请"),
    ALLOT_18(111,ALLOT.id, SIGN_WAIT_CONFIRM.id, WAIT_SIGN.id, "同意电子签章申请"),
    ALLOT_19(112,ALLOT.id, WAIT_SIGN.id, ALLOTING.id, "盖电子签章并出库"),
    ALLOT_BACK_8(113, ALLOT_BACK.id, ORIGIN_STATUS.id, BACK_SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    ALLOT_BACK_9(114,ALLOT_BACK.id, BACK_DRAFT.id, BACK_SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    ALLOT_BACK_10(115,ALLOT_BACK.id, BACK_SIGN_WAIT_CONFIRM.id, BACK_DRAFT.id, "拒绝电子签章申请"),
    ALLOT_BACK_11(116,ALLOT_BACK.id, BACK_SIGN_WAIT_CONFIRM.id, BACK_WAIT_SIGN.id, "同意电子签章申请"),
    ALLOT_BACK_12(117,ALLOT_BACK.id, BACK_WAIT_SIGN.id, ALLOT_BACKING.id, "盖电子签章并出库"),
    ALLOT_BACK_13(118,ALLOT_BACK.id, BACK_WAIT_SIGN.id, END.id, "盖电子签章并入库"),
    ALLOT_BACK_14(119,ALLOT_BACK.id, BACK_WAIT_SIGN.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, "盖电子签章并入库"),


    ALLOT_20(120,ALLOT.id, WAIT_SIGN.id, END.id, "上传相关单据，任务结束"),
    ALLOT_21(121,ALLOT.id, WAIT_SIGN.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, "盖电子签章"),//
    ALLOT_22(122,ALLOT.id, SIGN_WAIT_CONFIRM.id, ALLOTING.id, "拒绝电子签章申请"),
    ALLOT_BACK_15(123,ALLOT_BACK.id, BACK_SIGN_WAIT_CONFIRM.id, ALLOT_BACKING.id, "拒绝电子签章申请"),
    REPAIR_SEND_14(124, REPAIR.id, ORIGIN_STATUS.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    REPAIR_SEND_15(125,REPAIR.id, REPAIR_SEND_DRAFT.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    REPAIR_SEND_16(126,REPAIR.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, REPAIR_SEND_DRAFT.id, "拒绝电子签章申请"),
    REPAIR_SEND_17(127,REPAIR.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, REPAIR_SEND_WAIT_SIGN.id, "同意电子签章申请"),
    REPAIR_SEND_18(128,REPAIR.id, REPAIR_SEND_WAIT_SIGN.id, WAIT_RECEIVE.id, "盖电子签章并出库"),///???
//    REPAIR_SEND_19(129,REPAIR.id, REPAIR_SEND_WAIT_SIGN.id, END.id, "盖电子签章并入库"),
    REPAIR_SEND_19(129,REPAIR.id, REPAIR_SEND_WAIT_SIGN.id, END.id, "上传相关单据，业务办结"),
    REPAIR_SEND_20(130,REPAIR.id, REPAIR_SEND_WAIT_SIGN.id, WAIT_UPLOAD_FILE.id, "盖电子签章并入库"),
    REPAIR_SEND_21(131,REPAIR.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, WAIT_RECEIVE.id, "拒绝电子签章申请"),

    REPAIR_BACK_14(132, REPAIR.id, ORIGIN_STATUS.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, "申请电子签章"),
    REPAIR_BACK_16(134,REPAIR.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, REPAIR_BACK_DRAFT.id, "拒绝电子签章申请"),
    REPAIR_BACK_17(135,REPAIR.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, REPAIR_BACK_WAIT_SIGN.id, "同意电子签章申请"),
//    REPAIR_BACK_18(136,REPAIR.id, REPAIR_BACK_WAIT_SIGN.id, WAIT_BACK_RECEIVE.id, "盖电子签章并出库"),
    REPAIR_BACK_18(136,REPAIR.id, REPAIR_BACK_WAIT_SIGN.id, WAIT_BACK_RECEIVE.id, "等待接收维修装备"),
    REPAIR_BACK_19(137,REPAIR.id, REPAIR_BACK_WAIT_SIGN.id, END.id, "盖电子签章并出库"),
//    REPAIR_BACK_20(138,REPAIR.id, REPAIR_BACK_WAIT_SIGN.id, WAIT_UPLOAD_BACK_FILE.id, "盖电子签章并入库"),
    REPAIR_BACK_20(138,REPAIR.id, REPAIR_BACK_WAIT_SIGN.id, WAIT_UPLOAD_BACK_FILE.id, "上传签收单"),
    REPAIR_BACK_21(139,REPAIR.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, WAIT_BACK_RECEIVE.id, "拒绝电子签章申请"),
    APPLY_7(140,APPLY.id, WAIT_APPLY_FILE.id, END.id, "申请不同意，业务办结"),

//    ALLOT_BACK_16(141,ALLOT_BACK.id, BACK_DRAFT.id, ALLOT_BACKING.id, "从草稿发起退回"),
    ALLOT_BACK_17(142,ALLOT_BACK.id, ORIGIN_STATUS.id, BACK_DRAFT.id, "从草稿发起退回"),
    ALLOT_23(143,ALLOT.id, ALLOTING.id, SIGN_WAIT_CONFIRM.id, "申请入库签章"),
    ALLOT_24(144,ALLOT.id, ORIGIN_STATUS.id, WAIT_UPLOAD_ALLOT_FILE.id, "待上传回执单"),//0-322
    REPAIR_BACK_22(145,REPAIR_BACK.id, ORIGIN_STATUS.id, REPAIR_BACK_DRAFT.id, "维修退回等待出库"),
    REPAIR_BACK_23(146,REPAIR_BACK.id, REPAIR_BACK_DRAFT.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, "申请签章待审核"),
//    REPAIR_SEND_22(147,REPAIR.id, ORIGIN_STATUS.id, REPAIR_SEND_DRAFT.id, "送修等待出库"),
    REPAIR_SEND_23(148,REPAIR.id, ORIGIN_STATUS.id,  WAIT_UPLOAD_SEND_FILE.id, "等待上传回执单"),
    ALLOT_25(149,ALLOT.id,ALLOT_DRAFT.id,ALLOT_DRAFT.id,"申请电子签章被拒绝"),
    ALLOT_26(150,ALLOT.id,SIGN_WAIT_CONFIRM.id,ARCHIVE.id,"该业务已经被撤回"),
    ALLOT_27(151,REPAIR_BACK.id,ORIGIN_STATUS.id,WAIT_UPLOAD_BACK_SEND_FILE.id,"等待上传回执单"),
    REPAIR_BACK_24(152,REPAIR_BACK.id,REPAIR_BACK_SIGN_WAIT_CONFIRM.id,REPAIR_BACK_WAIT_SIGN.id,"同意签章审核"),
    REPAIR_BACK_25(153,REPAIR_BACK.id,WAIT_BACK_RECEIVE.id,REPAIR_BACK_SIGN_WAIT_CONFIRM.id,"等待签章审核"),
    REPAIR_BACK_26(154,REPAIR_BACK.id,REPAIR_BACK_SIGN_WAIT_CONFIRM.id,REPAIR_BACK_WAIT_SIGN.id,"等待签章审核"),
    REPAIR_BACK_27(155,REPAIR_BACK.id,REPAIR_BACK_WAIT_SIGN.id,WAIT_BACK_RECEIVE.id,"等待签章审核"),
    REPAIR_BACK_28(156,REPAIR_BACK.id,REPAIR_BACK_WAIT_SIGN.id,WAIT_UPLOAD_BACK_FILE.id,"等待上传相关单据"),
    ALLOT_28(157,ALLOT.id,ALLOTING.id,REVOKEALLOTTASK.id,"该业务已经被撤回"),
    ALLOT_29(158,ALLOT.id,WAIT_UPLOAD_ALLOT_FILE.id,REVOKEALLOTTASK.id,"该业务已经被撤回"),
    REPAIR_SEND_24(159,REPAIR.id, WAIT_RECEIVE.id, REPAIR_SEND_SIGN_WAIT_CONFIRM.id, "申请电子签章审核"),
    REPAIR_SEND_25(160,REPAIR.id, ORIGIN_STATUS.id, REPAIR_SEND_DRAFT.id, "等待出库"),
    REPAIR_BACK_30(161,REPAIR_BACK.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, REPAIR_BACK_DRAFT.id, "拒绝签章"),
    ALLOT_BACK_16(162,ALLOT_BACK.id, WAIT_UPLOAD_BACK_FILE_2.id, REVOKEALLOTTASK.id, "该业务已经(%sendUnit)被撤回"),
    ALLOT_BACK_18(163,ALLOT_BACK.id, ALLOT_BACKING.id, REVOKEALLOTTASK.id, "该业务已经(%sendUnit)被撤回"),
//    REPAIR_BACK_29(164,REPAIR_BACK.id, REPAIR_BACK_WAIT_SIGN.id, END.id, "上传相关单据，任务结束"),
    REPAIR_BACK_31(165,REPAIR_BACK.id, REPAIR_BACK_WAIT_SIGN.id, END.id, "上传相关单据，任务结束"),
    ALLOT_BACK_19(166,ALLOT_BACK.id, ORIGIN_STATUS.id, WAIT_UPLOAD_BACK_FILE_2.id, "待上传回执单"),
    ALLOT_BACK_20(167,ALLOT_BACK.id, ALLOT_BACKING.id, BACK_SIGN_WAIT_CONFIRM.id, "申请签章待审核"),
    REPAIR_BACK_32(168,REPAIR_BACK.id, REPAIR_BACK_SIGN_WAIT_CONFIRM.id, WAIT_BACK_RECEIVE.id, "等待接收维修退回装备"),
    //zsp: [业务操作日志]存储失败:找不到业务类型为+4,旧状态为0,新状态为400的日志模板
    SELF_CHECK_7(169, SELF_CHECK.id,ORIGIN_STATUS.id,WAIT_SELF_CHECK.id,"待自查任务"),
    //[业务操作日志]存储失败:找不到业务类型为+4,旧状态为400,新状态为8888的日志模板
    SELF_CHECK_8(170,SELF_CHECK.id,WAIT_SELF_CHECK.id,ARCHIVE.id,"核查结束，系统发起的自查自动结束"),
    ;

    public Integer id;

    /**
     * 业务类型
     */
    public Integer businessType;
    /**
     * 旧状态
     */
    public Integer oldStatus;

    /**
     * 新状态
     */
    public Integer newStatus;

    /**
     * 执行操作
     */
    public String operation;

    public String getOperation() {
        return this.operation;
    }
}
