package com.tykj.dev.config;

import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class TaskBeanConfig {

    private static final ThreadPoolTaskScheduler THREAD_POOL_TASK_SCHEDULER;

    static {
        THREAD_POOL_TASK_SCHEDULER = new ThreadPoolTaskScheduler();
        THREAD_POOL_TASK_SCHEDULER.setPoolSize(10);
        THREAD_POOL_TASK_SCHEDULER.initialize();
    }

    public static ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        return THREAD_POOL_TASK_SCHEDULER;
    }

    @Bean("taskScheduler")
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(10);
        return taskScheduler;
    }
}

