package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 装备列装性质枚举
 */

@AllArgsConstructor
public enum DeviceNature {
    /**
     * 指令型
     */
    NATURE_1(1, "指令型"),
    /**
     * 指导型
     */
    NATURE_2(2, "指导型"),
    /**
     * 专项型
     */
    NATURE_3(3, "专项型");

    public Integer id;

    public String name;

    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("列装性质");
        systemConfig.setEnglishName("nature");
        return systemConfig;
    }
}
