package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 装备形态枚举
 */

@AllArgsConstructor
public enum DeviceStyle {
    /**
     * 密码机
     */
    STYLE_1(1, "密码机"),
    /**
     * 密码模块
     */
    STYLE_2(2, "密码模块"),
    /**
     * 密码芯片
     */
    STYLE_3(3, "密码芯片"),
    /**
     * 说明书
     */
    STYLE_4(4, "说明书"),
    /**
     * U盘
     */
    STYLE_5(5, "U盘"),
    /**
     * 光盘
     */
    STYLE_6(6, "光盘"),
    /**
     * 密码软件
     */
    STYLE_7(7, "密码软件"),
    /**
     * 密码卡
     */
    STYLE_8(8, "密码卡"),
    STYLE_9(9, "其它");

    public Integer id;

    public String name;


    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("形态");
        systemConfig.setEnglishName("style");
        return systemConfig;
    }
}
