package com.tykj.dev.config.cache;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class ConfigCache {

    private Map<Integer, String> lifeStatusMap;

    private Map<Integer, String> matchingRangeMap;

    private Map<Integer, String> storageTypeMap;

    private Map<Integer, String> allotTypeMap;

    private Map<Integer, String> applyTypeMap;

    private Map<Integer, String> invisibleRangeMap;

    private Map<Integer, String> secretLevelMap;

    private Map<Integer, String> styleMap;

    private Map<Integer, String> natureMap;

    private Map<Integer, String> positionMap;

    private Map<Integer, String> storageLocationMap;


    public ConfigCache(List<SystemConfig> systemConfigs){
        this.lifeStatusMap = systemConfigs.stream().filter(systemConfig -> "lifeStatus".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.matchingRangeMap = systemConfigs.stream().filter(systemConfig -> "matchingRange".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.storageTypeMap = systemConfigs.stream().filter(systemConfig -> "storageType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.applyTypeMap = systemConfigs.stream().filter(systemConfig -> "applyType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.invisibleRangeMap = systemConfigs.stream().filter(systemConfig -> "invisibleRange".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.secretLevelMap = systemConfigs.stream().filter(systemConfig -> "secretLevel".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.styleMap = systemConfigs.stream().filter(systemConfig -> "style".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.natureMap = systemConfigs.stream().filter(systemConfig -> "nature".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.positionMap = systemConfigs.stream().filter(systemConfig -> "position".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.allotTypeMap = systemConfigs.stream().filter(systemConfig -> "allotType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.storageLocationMap = systemConfigs.stream().filter(systemConfig -> "storageLocation".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));

    }

    public Map<Integer, String> getMatchingRangeMap() {
        return matchingRangeMap;
    }

    public Map<Integer, String> getStorageTypeMap() {
        return storageTypeMap;
    }

    public Map<Integer, String> getApplyTypeMap() {
        return applyTypeMap;
    }

    public Map<Integer, String> getInvisibleRangeMap() {
        return invisibleRangeMap;
    }

    public Map<Integer, String> getSecretLevelMap() {
        return secretLevelMap;
    }

    public Map<Integer, String> getLifeStatusMap() {
        return lifeStatusMap;
    }

    public Map<Integer, String> getStyleMap() {
        return styleMap;
    }

    public Map<Integer, String> getNatureMap() {
        return natureMap;
    }

    public Map<Integer, String> getPositionMap() {
        return positionMap;
    }

    public Map<Integer, String> getAllotTypeMap() {
        return allotTypeMap;
    }

    public Map<Integer, String> getStorageLocationMap() {
        return storageLocationMap;
    }


    public ConfigCache refresh(List<SystemConfig> systemConfigs){
        this.lifeStatusMap = systemConfigs.stream().filter(systemConfig -> "lifeStatus".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.matchingRangeMap = systemConfigs.stream().filter(systemConfig -> "matchingRange".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.storageTypeMap = systemConfigs.stream().filter(systemConfig -> "storageType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.applyTypeMap = systemConfigs.stream().filter(systemConfig -> "applyType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.invisibleRangeMap = systemConfigs.stream().filter(systemConfig -> "invisibleRange".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.secretLevelMap = systemConfigs.stream().filter(systemConfig -> "secretLevel".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.styleMap = systemConfigs.stream().filter(systemConfig -> "style".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.natureMap = systemConfigs.stream().filter(systemConfig -> "nature".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.positionMap = systemConfigs.stream().filter(systemConfig -> "position".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.allotTypeMap = systemConfigs.stream().filter(systemConfig -> "allotType".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        this.storageLocationMap = systemConfigs.stream().filter(systemConfig -> "storageLocation".equals(systemConfig.getEnglishName())).collect(Collectors.toMap(SystemConfig::getValue, SystemConfig::getLabel));
        return this;
    }
}
