package com.tykj.dev.device.confirmcheck.entity.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * CheckBillVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/17 at 6:20 下午
 */
@SuppressWarnings("ALL")
@Data
@ApiModel("核查发起对象")
public class CheckBillVo {

    @ApiModelProperty(name = "业务标题", example = "浙江省手动核查测试")
    @JSONField(name = "title")
    private String checkTitle;

    @ApiModelProperty(name = "核查组成员A id", example = "1")
    private Integer userAId;

    @ApiModelProperty(name = "核查组成员B id", example = "2")
    private Integer userBId;

    @ApiModelProperty(name = "发起单位id", example = "1")
    private Integer unitId;

    @ApiModelProperty(name = "要核查的区域id数组", example = "[\"2\"]")
    private List<Integer> areaRange;

    @ApiModelProperty(name = "备注", example = "这是一段测试数据")
    private String remark;
}
