package com.tykj.dev.device.confirmcheck.entity.vo;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.util.List;

/**
 * StatLinkVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/5/13 at 7:43 下午
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel("统一跳转对象")
public class LinkVo {

    /**
     * 1 省统计 2 市检查 3 详情跳转
     */
    private int type;

    /**
     * 核查/检查总标题
     */
    private String title;

    private LocalDate endTime;

    /**
     * 里面装的都是检查数据
     */
    private List<LinkCheckDetail> lcDetail;

    /**
     * 里面装的都是自查数据
     */
    private List<LinkExamDetail> leDetail;

    private int detailId;

    public LinkVo(int type, LocalDate endTime) {
        this.type = type;
        this.endTime = endTime;
    }
}
