package com.tykj.dev.device.confirmcheck.service;

import com.tykj.dev.device.confirmcheck.common.TaskPeriod;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckBill;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckDetail;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckPeriod;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
import com.tykj.dev.device.confirmcheck.entity.vo.CheckBillSelectVo;
import com.tykj.dev.device.confirmcheck.entity.vo.CheckStatTableVo;
import org.springframework.data.domain.Page;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * CheckStatService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/10/13 at 3:58 下午
 */
public interface ConfirmCheckService {

    /**
     * 根据关键字查询报告列表
     * @return {@link CheckStatTableVo} 's List
     */
    Page<CheckStatTableVo> findAllStatTable(CheckBillSelectVo checkBillSelectVo);

    /**
     * 开启自动核查
     * @return 自动核查所开启的统计以及详情的账单id和任务id集合
     */
    Map<String, List<Integer>> autoCheck();

    /**
     * 更新自动核查的任务周期
     *
     * @param taskPeriod 要更新成为的周期
     * @return 周期表的最新id
     */
    Integer updateTaskPeriod(TaskPeriod taskPeriod);

    /**
     * 获得当前自动核查的任务周期
     *
     * @return 当前的 {@link TaskPeriod}
     */
    DeviceCheckPeriod getCurrentTaskPeriod();

    /**
     * 获得下一次计划任务的执行时间
     * @return 下次计划任务的执行时间
     */
    LocalDate getNextTaskDate();

    /**
     * 开启自动核查计划任务
     *
     * @return 任务是否开启成功
     */
    boolean startAutoCheckCron();

    /**
     * 关闭自动核查计划任务
     *
     * @return 任务是否关闭成功
     */
    boolean stopAutoCheckCron();

    /**
     * @param deviceCheckBills
     * DeviceCheckBill异步上链
     */
    void sendHash1(List<DeviceCheckBill> deviceCheckBills);

    /**
     * @param deviceCheckDetails
     * DeviceCheckDetail异步上链
     */
    void sendHash2(List<DeviceCheckDetail> deviceCheckDetails);

    /**
     * @param deviceCheckStats
     * DeviceCheckStat异步上链
     */
    void sendHash3(List<DeviceCheckStat> deviceCheckStats);
}
