package com.tykj.dev.device.confirmcheck.utils;

import com.tykj.dev.device.confirmcheck.common.CheckType;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
import com.tykj.dev.device.confirmcheck.entity.vo.CheckStatVo;
import com.tykj.dev.misc.base.BeanHelper;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;

/**
 * MapperHelper.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/10/26 at 2:50 下午
 */
public class MapperHelper {

    private static ModelMapper mapper = BeanHelper.getUserMapper();

    static {
        Converter<CheckType, Integer> checkTypeConverter =
                ctx -> ctx.getSource() == null ? 0 : ctx.getSource().getId();

        mapper.typeMap(DeviceCheckStat.class, CheckStatVo.class)
                .addMappings(mapping -> mapping
                        .using(checkTypeConverter)
                        .map(DeviceCheckStat::getCheckType, CheckStatVo::setCheckType));
    }

    public static ModelMapper getMapper() {
        return mapper;
    }
}
