package com.tykj.dev.device.decommissioning.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningOrderOutData;
import com.tykj.dev.device.decommissioning.entity.vo.StorageDeviceDevommissiong;
import com.tykj.dev.device.decommissioning.service.DeviceDecommissioningBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelDevController.java
 * @Description TODO
 * @createTime 2021年01月10日 13:52:00
 */
@RestController
@Api(tags = "装备退役业务接口模块", description = "包括装备退役业务相关接口")
@AutoDocument
@RequestMapping("/decommissioning")
public class DecommissioningDevController {

    @Autowired
    DeviceDecommissioningBusinessService deviceDecommissioningBusinessService;

    /**
     * 省清退中办
     */
    @ApiOperation(value = "省清退中办", notes = "省清退中办")
    @PostMapping(value ="/provinceSendOutSuperior/{userId}")
    public ResponseEntity provinceSendOutSuperior(@PathVariable Integer userId, @RequestBody DecommissioningOrderOutData orderOutData){
//        repelBusinessService.provinceSendOutSuperior(userId,orderOutData);
        return ResponseEntity.ok(deviceDecommissioningBusinessService.provinceSendDecommissioning(userId,orderOutData));
    }


    /**
     * 退役任务保存草稿
     */
    @ApiOperation(value = "退役任务保存草稿", notes = "退役任务保存草稿")
    @PostMapping(value ="/saveDeviceDecommissioningDraft/{userId}")
    public ResponseEntity saveDeviceDecommissioningDraft(@PathVariable Integer userId, @RequestBody DecommissioningOrderOutData orderOutData){
        return ResponseEntity.ok(deviceDecommissioningBusinessService.saveDeviceDecommissioningDraft(userId,orderOutData));
    }

    /**
     * 出库把任务推送至盖章审核
     */
    @ApiOperation(value = "出库把任务推送至盖章审核", notes = "出库把任务推送至盖章审核")
    @PostMapping(value ="/sealOfAudit/{userId}")
    public ResponseEntity sealOfAudit(@PathVariable Integer userId, @RequestBody DecommissioningOrderOutData orderOutData){
        deviceDecommissioningBusinessService.sealOfAudit(userId,orderOutData);
        return ResponseEntity.ok("退役任务保存草稿成功");
    }

    /**
     *  出库盖章审核调用
     */
    @ApiOperation(value = "退役出库盖章审核调用", notes = "退役出库盖章审核调用")
    @PostMapping(value ="/outSealOfAuditEnd/{reviewTheResults}/{taskId}")
    public ResponseEntity outSealOfAuditEnd(@PathVariable Integer reviewTheResults,@PathVariable Integer taskId){
        deviceDecommissioningBusinessService.outSealOfAuditEnd(taskId,reviewTheResults);
        return ResponseEntity.ok("盖章审核成功");
    }

    /**
     * 省上传中办回执单
     */
    @ApiOperation(value = "省上传中办回执单", notes = "省上传中办回执单")
    @PostMapping(value ="/receiptSingle/{taskId}")
    public ResponseEntity receiptSingle(@PathVariable Integer taskId, @RequestBody StorageDeviceDevommissiong storageDeviceRepel){
        deviceDecommissioningBusinessService.receiptSingle(taskId,storageDeviceRepel);
        return ResponseEntity.ok("省上传中办回执单,成功任务结束");
    }


    /**
     * 退役草稿任务封存
     */
    @ApiOperation(value = "退役草稿任务封存", notes = "退役草稿任务封存")
    @PostMapping(value ="/moveToArchiveDecommissioning/{taskId}")
    public ResponseEntity deleteDrafts(@PathVariable Integer taskId){
        deviceDecommissioningBusinessService.deleteDrafts(taskId);
        return ResponseEntity.ok("退役草稿任务封存成功,任务结束");
    }

}
