package com.tykj.dev.device.decommissioning.service;

import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningSelectVo;
import com.tykj.dev.device.decommissioning.entity.vo.PagingVo;
import com.tykj.dev.device.decommissioning.entity.vo.RepelManagementVo;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDecommissioningQueryService.java
 * @Description TODO
 * @createTime 2021年03月29日 16:39:00
 */
public interface DeviceDecommissioningQueryService {
    /**
     * 查询待中机回执业务代办
     */
    List<TaskBto> findOutsideTheProvince();

    /**
     * 查询退役办结业务
     */
    List<TaskBto> findOutsideTheProvinceEnd();

    /**
     * 查看退役中装备列表
     * @param repelManagementVo 查询条件对象
     * @return PagingVo
     */
    PagingVo findRetired(RepelManagementVo repelManagementVo);


    /**
     * 查看待退役列表装备
     */
    PagingVo toBeRetiredDeviceList(RepelManagementVo repelManagementVo);


    /**
     * 查看已退役装备列表
     */
    PagingVo retiredDeviceList(RepelManagementVo repelManagementVo);



    /**
     * 根据taskId查询退役业务详情
     */
    DeviceDecommissioningDetail findTaskIdDeviceDecommissioningDetail(Integer task);

    /**
     * 根据申请id查询退役任务
     */
    TaskBto findApplyIdToDecommissioningTask(Integer applyId);

    Page<DeviceDecommissioningDetail> findPageDeviceDecommissioningDetail(DecommissioningSelectVo decommissioningSelectVo);

    /**
     * 根据taskId查询相关文件接口（设备日志使用）
     */
    Map<String, List<FileRet>> findByTaskIdToFileMapList(Integer taskId);
}
