package com.tykj.dev.device.destroy.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.destroy.entity.vo.DeviceDestroyBillVo;
import com.tykj.dev.device.destroy.service.DeviceDestroyBusinessService;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;


/**
 * @author huangxiahao
 */
@RestController
@RequestMapping(value = "/destroy")
@AutoDocument
@Api(tags = "销毁业务模块", value = "销毁业务模块")
public class DeviceDestroyController {
    @Autowired
    DeviceDestroyBusinessService deviceDestroyBusinessService;

    /**
     * 保存报废草稿
     */
    @ApiOperation(value = "保存报废草稿", notes = "保存报废草稿")
    @PostMapping(value ="/saveDeviceDestroyBill")
    public ResponseEntity saveDeviceDestroyBill(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody DeviceDestroyBillVo deviceDestroyBillVo){
        return ResponseEntity.ok(deviceDestroyBusinessService.saveDeviceDestroyBill(securityUser,deviceDestroyBillVo));
    }

    /**
     * 发起销毁任务
     */
    @ApiOperation(value = "发起销毁任务", notes = "发起销毁任务")
    @PostMapping(value ="/provinceDeviceDestroyBill")
    public ResponseEntity provinceDeviceDestroyBill(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody DeviceDestroyBillVo deviceDestroyBillVo){
        return ResponseEntity.ok(deviceDestroyBusinessService.provinceDeviceDestroyBill(securityUser,deviceDestroyBillVo));
    }

    /**
     * 上传销毁单，任务完结
     */
    @ApiOperation(value = "上传销毁单，任务完结", notes = "上传销毁单，任务完结")
    @PostMapping(value ="/provinceDeviceDestroyBill/{taskId}")
    public ResponseEntity provinceDeviceDestroyBill(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody DeviceDestroyBillVo deviceDestroyBillVo, @PathVariable Integer taskId){
        deviceDestroyBusinessService.receiptSingle(taskId,deviceDestroyBillVo,securityUser);
        return ResponseEntity.ok("上传销毁单成功，任务完结");
    }

    /**
     * 销毁草稿任务封存完成
     */
    @ApiOperation(value = "销毁草稿任务封存", notes = "销毁草稿任务封存")
    @PostMapping(value ="/moveToArchiveDestroyBill/{taskId}")
    public ResponseEntity moveToArchiveDestroyBill(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@PathVariable Integer taskId){
        deviceDestroyBusinessService.moveToArchiveDestroyBill(taskId);
        return ResponseEntity.ok("销毁草稿任务封存完成");
    }

}
