package com.tykj.dev.device.destroy.service;


import com.tykj.dev.device.destroy.entity.domain.DeviceDestroyBill;
import com.tykj.dev.device.destroy.entity.vo.DestroySelectVo;
import com.tykj.dev.device.file.entity.FileRet;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zjm
 */
public interface DeviceDestroyBillService {
    /**
     * 添加报废详情
     * @return 报废详情对象
     */
    DeviceDestroyBill saveDeviceDestroyBill(DeviceDestroyBill scrap);

    /**
     * 根据报废详情id查询清退详情
     * @param scrapId 报废详情id
     * @return 详情对象
     */
    DeviceDestroyBill findDeviceDestroyBill(Integer scrapId);


    /**
     * 查询所有的报废任务
     */
    List<DeviceDestroyBill> findAll();

//    Page<DeviceDestroyBill> findPageScrapList(ScrapSelectVo scrapSelectVo);

    /**
     * 根据申请id查询报废任务
     */
    Optional<DeviceDestroyBill> findApplyId(Integer applyId);

    Page<DeviceDestroyBill> findPageDeviceDestroyBill(DestroySelectVo destroySelectVo);

    Map<String, List<FileRet>> findByIdToFileMapList(Integer id);
}
