package com.tykj.dev.device.destroy.service;

import com.tykj.dev.device.destroy.entity.domain.DeviceDestroyBill;
import com.tykj.dev.device.destroy.entity.vo.DestroySelectVo;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDestroyQueryService.java
 * @Description TODO
 * @createTime 2021年04月09日 10:52:00
 */
public interface DeviceDestroyQueryService {
//    Page<DeviceDestroyBill> findPageScrapList(ScrapSelectVo scrapSelectVo);

    /**
     * 根据taskId查询报废详情
     * @param taskId 任务id
     * @return 详情
     */
    DeviceDestroyBill findTaskId(Integer taskId);

    TaskBto findApplyIdToDeviceDestroyTask(Integer applyId);

    Page<DeviceDestroyBill> findPageDeviceDestroyBill(DestroySelectVo destroySelectVo);

    /**
     * 根据taskId查询相关文件接口（设备日志使用）
     */
    Map<String,List<FileRet>> findByTaskIdToFileMapList(Integer taskId);
}
