package com.tykj.dev.device.destroy.service.Impl;

import com.tykj.dev.device.destroy.entity.domain.DeviceDestroyBill;
import com.tykj.dev.device.destroy.entity.vo.DestroySelectVo;
import com.tykj.dev.device.destroy.service.DeviceDestroyBillService;
import com.tykj.dev.device.destroy.service.DeviceDestroyQueryService;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDestroyQueryServiceImpl.java
 * @Description TODO
 * @createTime 2021年04月09日 13:03:00
 */
@Service
@Slf4j
public class DeviceDestroyQueryServiceImpl implements DeviceDestroyQueryService {
    @Autowired
    DeviceDestroyBillService  deviceDestroyBillService;

    @Autowired
    TaskService taskService;

    @Override
    public DeviceDestroyBill findTaskId(Integer taskId) {
       TaskBto taskBto= taskService.get(taskId);
       return deviceDestroyBillService.findDeviceDestroyBill(taskBto.getBillId());
    }

    @Override
    public TaskBto findApplyIdToDeviceDestroyTask(Integer applyId) {
        Optional<DeviceDestroyBill> deviceDestroyBill= deviceDestroyBillService.findApplyId(applyId);
        if (!deviceDestroyBill.isPresent()){
            return null;
        }else {
            Optional<Task> billIdAndBusinessType = taskService.findBillIdAndBusinessType(deviceDestroyBill.get().getId(), BusinessEnum.DESTROY.id,StatusEnum.ARCHIVE.id);
            if (billIdAndBusinessType.isPresent()){
                TaskBto taskBto=billIdAndBusinessType.get().parse2Bto();

                return taskBto;
            }else {
                log.info("[销毁] 根据申请id未查询退役任务 ：{}",applyId);
//                throw new ApiException(ResponseEntity.status(500).body("[销毁] 根据申请id未查询退役任务 ："+applyId));
            return null;
            }
        }
    }

    @Override
    public Page<DeviceDestroyBill> findPageDeviceDestroyBill(DestroySelectVo destroySelectVo) {
        return deviceDestroyBillService.findPageDeviceDestroyBill(destroySelectVo);
    }


    @Override
    public Map<String, List<FileRet>> findByTaskIdToFileMapList(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        return deviceDestroyBillService.findByIdToFileMapList(taskBto.getBillId());
    }
}
