package com.tykj.dev.device.file.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Destruction.java
 * @Description 销毁单据属性对象
 * @createTime 2021年02月03日 15:36:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class Destruction {
    @ApiModelProperty(name = "抬头")
    private String title;

    @ApiModelProperty(name = "销毁单位")
    private String disposeUnitName;

    @ApiModelProperty(name = "报废时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date time;

    @ApiModelProperty(name = "单据号")
    private String number;

    private List<DocumentDevice> confirmDevices;

}
