package com.tykj.dev.device.finalcheck.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * finalReportVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/24 at 5:28 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("决算报告概览")
@ExcelTarget("FinalReport")
public class FinalReportVo {

    @ApiModelProperty("主键")
    private Integer id;

    @Excel(name = "名称")
    @ApiModelProperty("决算名称")
    private String name;

    @Excel(name = "决算单位")
    @ApiModelProperty("单位")
    private String unitName;

    @Excel(name = "发起时间")
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("决算开始时间")
    private LocalDate startTime;

    @Excel(name = "截止时间")
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("决算结束时间")
    private LocalDate endTime;

    @Excel(name = "报告生成时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("报告生成时间")
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDateTime reportTime;

    @Excel(name = "操作人")
    @ApiModelProperty("操作人姓名")
    private String operator;

    @ApiModelProperty("报告细节列表")
    private List<FinalDetailVo> details;

}
