package com.tykj.dev.device.library.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.service.DeviceLibraryCacheService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * DATE:2021-8-11
 * Author:zsp
 */
@RestController
@RequestMapping(value = "/cacheLibrary")
@AutoDocument
@Api(tags = "装备缓存模块", description = "装备缓存接口")
@Slf4j
public class CacheLibraryController {

    @Autowired
    private DeviceLibraryCacheService cacheLibraryService;

    @GetMapping("getAll")
    public List<DeviceLibrary> getAll(){
        return cacheLibraryService.getAllDeviceLibraryList();
    }
}
