package com.tykj.dev.device.library.subject.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;

/**
 * entity class for device_library
 * 装备库
 */
@Data
@ApiModel("装备库")
@AllArgsConstructor
@NoArgsConstructor
public class DeviceExcel {

    /**
     * 主键id
     */
    @Id
    @Excel(name = "id", orderNum = "1", width = 30, needMerge = true)
    private Integer id;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    @Excel(name = "型号", orderNum = "1", width = 30, needMerge = true)

    private String model;

    /**
     * 装备名称
     */
    @ApiModelProperty(value = "装备名称")
    @Excel(name = "装备名称", orderNum = "1", width = 30, needMerge = true)

    private String name;

    /**
     * 密级
     */
    @ApiModelProperty(value = "密级")
    @Excel(name = "密级", orderNum = "1", width = 30, needMerge = true)

    private String secretLevelName;

    /**
     * 装备序列号
     */
    @ApiModelProperty(value = "装备序列号")
    @Excel(name = "装备序列号", orderNum = "1", width = 30, needMerge = true)
    private String seqNumber;

    /**
     * 生产序列号
     */
    @ApiModelProperty(value = "生产序列号")
    @Excel(name = "生产序列号", orderNum = "1", width = 30, needMerge = true)
    private String prodNumber;

    /**
     * rfid表面号
     */
    @ApiModelProperty(value = "rfid表面号")
    @Excel(name = "rfid表面号", orderNum = "1", width = 30, needMerge = true)

    private String rfidSurfaceId;
    /**
     * 类型
     */
    @ApiModelProperty(value = "类型")
    @Excel(name = "类型", orderNum = "1", width = 30, needMerge = true)

    private String typeName;

    /**
     * 生命状态,0-入库待审核,1-入库审核失败,2-在库,3-配发,4-维修,5,维修失败,6-退回,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失 12.清退
     */
    @ApiModelProperty(value = "生命状态,0-入库待审核,1-入库审核失败,2-在库,3-配发,4-维修,5,维修失败,6-退回,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失")
    @Excel(name = "生命状态", orderNum = "1", width = 30, needMerge = true)
    private String lifeStatusName;
}
