package com.tykj.dev.device.matching.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * @author dengdiyi
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update matching_repair_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配套维修单")
public class MatchingRepairBill {

    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(name = "配套设备id")
    private Integer deviceId;

    @ApiModelProperty(name = "维修描述")
    private String remark;

    @ApiModelProperty(name = "维修单名字")
    private String fileName;

    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(name = "维修单URL")
    private String fileUrl;

    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
}
