package com.tykj.dev.device.packing.subject.domin;

import com.tykj.dev.device.library.subject.vo.DeviceLogUserVo;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for packing_log
 * 列装履历日志
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update packing_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("列装履历日志")
public class PackingLog {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 装备id
     */
    @ApiModelProperty(value = "列装id")
    private Integer packingId;
    /**
     * 操作描述
     */
    @ApiModelProperty(value = "操作描述")
    private String remark;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    /**
     * dto类转化为vo类
     */
    public DeviceLogUserVo toVo() {
        UserPublicService userPublicService = SpringUtils.getBean("userPublicServiceImpl");
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        DeviceLogUserVo deviceLogUserVo = modelMapper.map(this, DeviceLogUserVo.class);
        //set vo字段
        if (userPublicService != null && this.createUserId != null) {
            User user = userPublicService.getOne(this.createUserId);
            deviceLogUserVo.setUser(user.getName());
            deviceLogUserVo.setUnit(userPublicService.findUnitsNameByUserId(this.createUserId));
            deviceLogUserVo.setPhoneNum(user.getMobile());
        }
        return deviceLogUserVo;
    }

}
