package com.tykj.dev.device.packing.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("列装型号编辑类")
public class PackingModelEdit {

    @NotNull(message = "model不能为空")
    @ApiModelProperty(value = "型号")
    private String model;

    @NotNull(message = "secretLevel不能为空")
    @ApiModelProperty(value = "密级")
    private Integer secretLevel;

    @NotNull(message = "invisibleRange不能为空")
    @ApiModelProperty(value = "可见范围")
    private Integer invisibleRange;

    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "列装状态")
    private Integer status;

//    @NotNull(message = "showOrder不能为空")
    @ApiModelProperty(value = "排序号")
    private Integer showOrder;

    @ApiModelProperty(value = "列装装备id", example = "1")
    @NotNull(message = "packingId不能为空")
    private Integer packingId;

    @ApiModelProperty(value = "序号")
    private Integer seqOrderNumber;
}
