package com.tykj.dev.device.questionbank.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.questionbank.entity.Problem;
import com.tykj.dev.device.questionbank.entity.vo.ProblemPageVo;
import com.tykj.dev.device.questionbank.service.ProblemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description TODO
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "题库展示层", description = "题库展示层")
@AutoDocument
@RequestMapping("/questionBack")
public class QuestionBackController {

    @Autowired
    ProblemService problemService;


    /**
     * 添加题目
     */
    @ApiOperation(value = "添加题目")
    @PostMapping("/save")
    public ResponseEntity findOutsideTheProvince(@RequestBody Problem problem) {
        return ResponseEntity.ok(problemService.saveProble(problem));
    }


    /**
     * 查询题目 -分页
     */
    @ApiOperation(value = "分页查询题目")
    @PostMapping("/find/page")
    public ResponseEntity findAllPage(@RequestBody ProblemPageVo problemPageVo) {
        return ResponseEntity.ok(problemService.pageProblemSelect(problemPageVo));
    }


    /**
     * 根据id删除题目
     */
    @ApiOperation(value = "根据id删除题目")
    @GetMapping("/delete/{id}")
    public ResponseEntity deleteById( @PathVariable Integer id) {
        problemService.deleteById(id);
        return ResponseEntity.ok("删除成功");
    }

    /**
     * 根据id集合批量删除题目
     */
    @ApiOperation(value = "根据id集合批量删除题目")
    @PostMapping("/delete/ids")
    public ResponseEntity deleteByIds(@RequestBody List<Integer> ids) {
        problemService.deleteByIds(ids);
        return ResponseEntity.ok("删除成功");
    }


    /**
     * 查询题库的情况
     */
    @ApiOperation(value = "查询题库的情况")
    @GetMapping("/getProblemCount")
    public ResponseEntity getProblemCount() {

        return ResponseEntity.ok(problemService.getProblemCount());
    }



}
