package com.tykj.dev.device.questionbank.entity;

import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Problem.java
 * @Description 存放题目相关信息
 * @createTime 2021年05月29日 14:47:00
 */
@ApiModel("题目对象")
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class Problem extends BaseEntity {
    @Column(name = "des" ,columnDefinition = "TEXT")
    @ApiModelProperty(value = "题目描述")
    private String des;

    @Column(name = "problem_answer" ,columnDefinition = "TEXT")
    @ApiModelProperty(value = "题目答案")
    private String problemAnswer;

//    1.选 2判断 3解答 4多选
    @ApiModelProperty(value = "题目类型")
    private Integer problemType;

    @ApiModelProperty(value = "题目难度")
    private Integer problemLevel;

    @ApiModelProperty(value = "题目选项")
    @Column(name = "choose_options" ,columnDefinition = "TEXT")
    private String chooseOptions;

    @Transient
    //选项 type为1时使用
    @ApiModelProperty(value = "题目选项集合 ")
    private List<String> chooseOptionsList;



}
