package com.tykj.dev.device.retired.service.Impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.blockcha.subject.entity.BcHash;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.TaskBeanConfig;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.retired.entity.domain.DeviceRetiredBill;
import com.tykj.dev.device.retired.repository.DeviceRetiredBillDao;
import com.tykj.dev.device.retired.service.DeviceRetiredBillService;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceRetiredBillServiceImpl
 * @packageName com.tykj.dev.device.retired.subject.service
 **/
@Service
public class DeviceRetiredBillServiceImpl implements DeviceRetiredBillService {

    @Autowired
    DeviceRetiredBillDao deviceRetiredBillDao;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Autowired
    private BlockChainUtil blockChainUtil;

    @Override
    public DeviceRetiredBill addEntity(DeviceRetiredBill deviceRetiredBillEntity) {
        DeviceRetiredBill deviceRetiredBill = deviceRetiredBillDao.save(deviceRetiredBillEntity);
        CompletableFuture.runAsync(()->{
            DeviceRetiredBill deviceRetiredBill1 = getOne(deviceRetiredBill.getId());
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(deviceRetiredBill1));
            String recordId = bcText.getData().getRecordID();
            deviceRetiredBill1.setRecordId(recordId);
            deviceRetiredBillDao.save(deviceRetiredBill1);
        }, TaskBeanConfig.getThreadPoolTaskScheduler());
        return deviceRetiredBill;
    }

    /**
     * @param deviceRetiredBills 异步上链
     */
    @Override
    @Async
    public void sendHash(List<DeviceRetiredBill> deviceRetiredBills) {
        deviceRetiredBills.forEach(deviceRetiredBill -> {
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(deviceRetiredBill));
            String recordId = bcText.getData().getRecordID();
            deviceRetiredBill.setRecordId(recordId);
            update(deviceRetiredBill);
        });
    }


    @Override
    public DeviceRetiredBill getOne(Integer id) {
        Optional<DeviceRetiredBill> resultEntity = deviceRetiredBillDao.findById(id);
        return resultEntity.orElse(null);
    }

    @Override
    public DeviceRetiredBill update(DeviceRetiredBill deviceRetiredBillEntity) {
        DeviceRetiredBill deviceRetiredBill = deviceRetiredBillDao.save(deviceRetiredBillEntity);
        CompletableFuture.runAsync(()->blockChainUtil.appendHash(JacksonUtil.toJSon(deviceRetiredBill),deviceRetiredBill.getRecordId()),TaskBeanConfig.getThreadPoolTaskScheduler());
        return deviceRetiredBill;
    }

    @Override
    public void delete(Integer id) {
        deviceRetiredBillDao.deleteById(id);
    }

    @Override
    public Long getCantPackingCount(Integer packingLibraryId) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        predicateBuilder.notIn("lifeStatus", 5,10,12,13);
        predicateBuilder.eq("packingId", packingLibraryId);
        return deviceLibraryDao.count(predicateBuilder.build());
    }


}
