package com.tykj.dev.device.scrap.subject.vo;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.scrap.subject.domin.ScrapBill;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报废单存储类", description = "报废单存储类")
public class ScrapSaveVo {

//    @NotNull(message = "repairBillId不能为空")
    @Min(value = 1,message = "repairBillId不能小于1")
    @ApiModelProperty(value = "维修单id")
    private Integer repairBillId;

    @NotNull(message = "scrapUnit不能为空")
    @ApiModelProperty(value = "报废单位")
    private String scrapUnit;

    @NotNull(message = "scrapTime不能为空")
    @ApiModelProperty(value = "报废时间")
    private Date scrapTime;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "经办人")
    private String manager;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "报废单文件名")
    private String fileName;

//    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "报废单文件URL")
    private String fileUrl;

    @NotEmpty(message = "deviceIds不能为空")
    @ApiModelProperty(value = "报废装备Id列表")
    private List<Integer> deviceIds;
    
    private List<ScriptSaveVo> scriptSaveVos = new ArrayList<>();

    public ScrapBill toDo() {
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        ScrapBill scrapBill = modelMapper.map(this, ScrapBill.class);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (this.deviceIds != null && this.deviceIds.size() > 0) {
            deviceIds.forEach(integer -> stringBuffer.append(integer).append("x"));
        }
        scrapBill.setScrapDetail(stringBuffer.toString());
        return scrapBill;
    }
}
