package com.tykj.dev.device.sendback.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.sendback.entity.vo.*;
import com.tykj.dev.device.sendback.service.AgainStorageBillService;
import com.tykj.dev.device.sendback.service.RepelQueryService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.device.task.utils.TaskUtils;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description 装备清退查询接口提供
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "装备清退查询接口模块", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/repelQuery")
public class RepelQueryController {
    @Autowired
    RepelQueryService repelQueryService;

    @Autowired
    TaskService taskService;

    @Autowired
    AgainStorageBillService againStorageBillService;

    @Autowired
    TaskUtils taskUtils;

    @GetMapping(value ="/repelTaskStatistical/{taskId}/{billId}")
    @ApiOperation(value = "省、市清退任务的统计页面详情", notes = "省、市清退任务的统计页面")
    public ResponseEntity findRepelTaskStatisticals(@PathVariable Integer taskId, @PathVariable Integer billId){
        return ResponseEntity.ok(repelQueryService.findRepelTaskStatisticals(taskId, billId));
    }

    @GetMapping(value ="/deviceRepelDetail/{taskId}")
    @ApiOperation(value = "统计任务审核页面详情", notes = "统计任务审核页面详情")
    public ResponseEntity findDeviceRepelDetail(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceRepelDetail(taskId));
    }

    @GetMapping(value ="/deviceRepel/{taskId}")
    @ApiOperation(value = "代办任务通知页面详情", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceRepel(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceRepel(taskId));
    }

    @PostMapping(value ="/deviceChooseRepel")
    @ApiOperation(value = "代办任务通知页面详情", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceRepel(@RequestBody DeviceChoosePageVo deviceChoosePageVo){
        return ResponseEntity.ok(repelQueryService.findDeviceChooseRepel(deviceChoosePageVo));
    }

    @PostMapping(value ="/idsList")
    @ApiOperation(value = "清退选择装备id集合", notes = "清退选择装备id集合")
    public ResponseEntity idsList(@RequestBody DeviceChoosePageVo deviceChoosePageVo){
        return ResponseEntity.ok(repelQueryService.findIdList(deviceChoosePageVo));
    }

    @PostMapping(value ="/deviceChooseRepel1")
    @ApiOperation(value = "省本级任务清退装备查询接口", notes = "省本级任务清退装备查询接口")
    public ResponseEntity findDeviceRepel1(@RequestBody DeviceChoosePageVo deviceChoosePageVo){
        return ResponseEntity.ok(repelQueryService.findDeviceChooseRepel1(deviceChoosePageVo));
    }

    @GetMapping(value ="/deviceSendOut/{taskId}")
    @ApiOperation(value = "出库查询装备", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceSendOut(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceSendOut(taskId));
    }

    @PostMapping(value ="/toRepelList")
    @ApiOperation(value = "待清退列表", notes = "待清退列表")
    public ResponseEntity toRepelList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.repelDeviceList(repelManagementVo));
    }

    @PostMapping(value ="/clearedList")
    @ApiOperation(value = "已清退列表", notes = "已清退列表")
    public ResponseEntity clearedList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.clearedList(repelManagementVo));
    }

    @PostMapping(value ="/retiredList")
    @ApiOperation(value = "已退役列表", notes = "已退役列表接口")
    public ResponseEntity retiredList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.retiredList(repelManagementVo));
    }

    @GetMapping(value ="/provinceDirectlyUnderDev/{taskId}/{type}")
    @ApiOperation(value = "省直属任务单位列表查询接口", notes = "省直属任务装备查询接口")
    public ResponseEntity provinceDirectlyUnderDev(@PathVariable Integer taskId, @PathVariable Integer type){
        return ResponseEntity.ok(repelQueryService.directlyUnderUnitLeftNavigation(taskId,type));
    }

    @PostMapping(value ="/repelManagementListDetails")
    @ApiOperation(value = "清退管理页面 统计列表数据点击接口", notes = "清退管理页面 统计列表数据点击接口")
    public ResponseEntity repelManagementListDetails(@RequestBody DeviceIdLIstVo deviceIdLIstVo){

        return ResponseEntity.ok(repelQueryService.repelManagementListDetails(deviceIdLIstVo.getIds()));
    }

    @GetMapping(value ="/provinceDirectlyUnderSelectedDev/{taskId}/{unitId}/{type}")
    @ApiOperation(value = "省直属单位 待上传接口装备查询", notes = "省直属单位 待上传接口装备查询")
    public ResponseEntity provinceDirectlyUnderSelectedDev(@PathVariable Integer taskId, @PathVariable Integer unitId, @PathVariable Integer type){
        return ResponseEntity.ok(repelQueryService.provinceDirectlyUnderSelectedDev(taskId,unitId,type));
    }

    @GetMapping(value ="/findByBillIdDeviceRepelDetail/{repelId}")
    @ApiOperation(value = "根据业务id查询清退详情", notes = "根据业务id查询清退详情")
    public ResponseEntity findByBillIdDeviceRepelDetail(@PathVariable Integer repelId){
        return ResponseEntity.ok(repelQueryService.findByBillIdDeviceRepelDetail(repelId));
    }

    @PostMapping(value ="/findRepelListModelNameGroup")
    @ApiOperation(value = "清退管理 选择装备列表的接口", notes = "清退管理 选择装备列表的接口")
    public ResponseEntity findRepelListModelNameGroup(@RequestBody ModelAndTypeVo modelAndTypeVo){
        return ResponseEntity.ok(repelQueryService.findRepelListModelNameGroup(modelAndTypeVo));
    }

    @ApiOperation(value = "查询清退单列表")
    @PostMapping("/getList")
    public ResponseEntity getList(@RequestBody RepelDetailSelectVo repelDetailSelectVo) {
        return ResponseEntity.ok(repelQueryService.getList(repelDetailSelectVo));
    }

    @ApiOperation(value = "查询清退任务", notes = "可以通过这个接口查询查询清退任务")
    @PostMapping(value = "/taskList")
    public ResponseEntity selectRepairTasks(@RequestBody TaskSelectVo taskSelectVo){
        List<TaskUserVo> taskUserVos = taskService.getManageList(taskSelectVo).stream().filter(taskUserVo -> taskUserVo.getBusinessType()==18||taskUserVo.getBusinessType()==16).collect(Collectors.toList());
        return ResultUtil.success(PageUtil.getPerPage(taskSelectVo.getPage(), taskSelectVo.getSize(), taskUtils.orderByTopDesc(taskUserVos), taskSelectVo.getPageable()));
    }

    @PostMapping(value ="/clearedDeviceList")
    @ApiOperation(value = "已清退", notes = "已清退列表")
    public ResponseEntity clearedList3(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.clearedDeviceList(repelManagementVo));
    }

    @PostMapping(value ="/againStorage/{taskId}")
    @ApiOperation(value = "重新入库查询业务详情", notes = "重新入库查询业务详情")
    public ResponseEntity findAgainStorage(@PathVariable Integer taskId){
        return ResponseEntity.ok(againStorageBillService.findByid(taskId));
    }

    @PostMapping(value ="/repelDeviceInList")
    @ApiOperation(value = "清退中", notes = "清退中列表")
    public ResponseEntity repelDeviceInList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.repelDeviceInList(repelManagementVo));
    }


    @GetMapping(value ="/provinceDirectlyUnder/device/{taskId}")
    @ApiOperation(value = "直属单位全部清退装备查询接口", notes = "直属单位全部清退装备查询接口")
    public ResponseEntity provinceDirectlyUnderDevice( @PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.provinceDirectlyUnderDev(taskId));
    }

    @PostMapping(value ="/judgeFieldingIsNotNormal")
    @ApiOperation(value = "判断发起的列装是否需要提示接口", notes = "判断发起的列装是否需要提示接口")
    public ResponseEntity provinceDirectlyUnderDevice(@RequestBody List<RepelFieldingVo> repelFieldingVoList){
        return ResponseEntity.ok(repelQueryService.judgeFieldingIsNotNormal(repelFieldingVoList));
    }

    @GetMapping(value ="/repel/fileMap/{taskId}")
    @ApiOperation(value = "根据任务ID查询业务相关单据", notes = "根据任务ID查询业务相关单据")
    public ResponseEntity repelFileMap( @PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findByTaskIdToFileMapList(taskId));
    }

}
