package com.tykj.dev.device.sendback.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * <h4>Description : 清退装备出库</h4>
 *
 * @Author czq
 * @Date 2020-08-17 14:38
 * @Version 1.0
 */
@Data
@ApiModel("清退装备出库")
public class SendBackOutVo {

    @ApiModelProperty(value = "经办人")
    private String name;

    @ApiModelProperty(value = "经办人id")
    private Integer id;

    @ApiModelProperty(value = "截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    @ApiModelProperty(value = "应出库")
    private Integer shouldOut;

    @ApiModelProperty(value = "实出库")
    private Integer actualOut;

    @ApiModelProperty(value = "出库确认单")
    private String url;

    @ApiModelProperty(value = "文件名")
    private String fileName;

    @ApiModelProperty(value = "审核人姓名")
    private String reviewerName;

    @ApiModelProperty(value = "审核人id")
    private Integer reviewerNameId;

    @ApiModelProperty(value = "发起人")
    private String startUserIdName;

    @ApiModelProperty(value = "出库装备清单")
    private List<DeviceLibrary> deviceLibraryEntities;

    /**
     * 接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @ApiModelProperty(value = "接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String receiveCheckDetail;
    /**
     * 接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
     */
    @ApiModelProperty(value = "接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条")
    private String receiveCheckResult;

//
//    @ApiModelProperty(value = "非在库装备")
//    private List<DeviceLibraryEntity> unDeviceLibraryEntities;
//
//    @ApiModelProperty(value = "非在库装备备注")
//    private HashMap<Integer,String> unDeviceDes;

    @ApiModelProperty(value = "出库装备审核结果")
    private HashMap<Integer, Integer> DeviceDes;


    @ApiModelProperty(value = "清退单url")
    private String returnNoteUrl;


    @ApiModelProperty(value = "清退单name")
    private String returnNoteName;

    @ApiModelProperty(value = "是否可以出库")
    private Integer isNotOutbound;

    @ApiModelProperty(value = "异常taskid")
    private Integer excTask;


}
