package com.tykj.dev.device.sendback.service;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import com.tykj.dev.device.sendback.entity.vo.RepelDetailSelectVo;
import org.springframework.data.domain.Page;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface DeviceRepelDetailService {
    /**
     * 添加清退详情
     * @return 清退详情对象
     */
    DeviceRepelDetail saveDeviceRepelDetail(DeviceRepelDetail deviceRepelDetail);

    /**
     * 根据清退详情id查询清退详情
     * @param repelDetailId 清退详情id
     * @return 详情对象
     */
    DeviceRepelDetail findDeviceRepelDetail(Integer repelDetailId);

    /**
     * 根据清退详情id查询清退详情（不包括装备详情）
     * @param repelDetailId 清退详情id
     * @return 详情对象
     */
    DeviceRepelDetail findDeviceRepelDetailNoDev(Integer repelDetailId);

    List<DeviceRepelDetail> findAll();

    /**
     * 根据年份以及单位 查询清退的装备列表
     */
    List<Integer> findYearAndUnitToDeviceList(Date time,Date endTime,Integer unitId);


    List<DeviceRepelDetail> findUnitIdSendOrReceive(Integer unitId);

    List<DeviceRepelDetail> findIdsReceiptUnits(List<Integer> unitIds);

    Page<DeviceRepelDetail> findPageDeviceRepelDetail(RepelDetailSelectVo  repelDetailSelectVo);


    Map<String, List<FileRet>> findByIdToFileMapList(Integer id);

}
